/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.output;

import java.util.Map;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutputMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.table.HBasePut;
import org.pentaho.hadoop.shim.api.hbase.table.HBaseTableWriteOperationManager;

public class KettleRowToHBaseTuple {
    private int keyIndex = -1;
    private ValueMetaInterface keyInMeta;
    private Mapping.KeyType keyType;
    private int familyIndex = -1;
    private ValueMetaInterface familyInMeta;
    private int columnIndex = -1;
    private ValueMetaInterface columnInMeta;
    private int valueIndex = -1;
    private ValueMetaInterface valueInMeta;
    private HBaseValueMetaInterface valueMeta;
    private int visibilityIndex = -1;
    private ValueMetaInterface visibilityInMeta;
    private HBaseValueMetaInterface visibilityMeta;

    public KettleRowToHBaseTuple(RowMetaInterface inputRowMeta, Mapping tupleMapping, Map<String, HBaseValueMetaInterface> columnMapping) throws KettleException {
        String keyName = tupleMapping.getKeyName();
        this.keyIndex = inputRowMeta.indexOfValue(keyName);
        if (this.keyIndex < 0) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoKeyColumn", (String[])new String[0]));
        }
        this.keyInMeta = inputRowMeta.getValueMeta(this.keyIndex);
        this.keyType = tupleMapping.getKeyType();
        this.familyIndex = inputRowMeta.indexOfValue(Mapping.TupleMapping.FAMILY.toString());
        if (this.familyIndex < 0) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoFamilyColumn", (String[])new String[0]));
        }
        this.familyInMeta = inputRowMeta.getValueMeta(this.familyIndex);
        this.columnIndex = inputRowMeta.indexOfValue(Mapping.TupleMapping.COLUMN.toString());
        if (this.columnIndex < 0) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoColumnColumn", (String[])new String[0]));
        }
        this.columnInMeta = inputRowMeta.getValueMeta(this.columnIndex);
        this.valueIndex = inputRowMeta.indexOfValue(Mapping.TupleMapping.VALUE.toString());
        if (this.valueIndex < 0) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoValueColumn", (String[])new String[0]));
        }
        this.valueInMeta = inputRowMeta.getValueMeta(this.valueIndex);
        this.valueMeta = columnMapping.get(this.valueInMeta.getName());
        this.visibilityIndex = inputRowMeta.indexOfValue("Visibility");
        if (this.visibilityIndex >= 0) {
            this.visibilityInMeta = inputRowMeta.getValueMeta(this.visibilityIndex);
            this.visibilityMeta = columnMapping.get(this.visibilityInMeta.getName());
            if (this.visibilityMeta == null) {
                this.visibilityInMeta = null;
                this.visibilityIndex = -1;
            }
        }
    }

    public HBasePut createTuplePut(HBaseTableWriteOperationManager hBaseTableWriteOperationManager, ByteConversionUtil bu, Object[] row, boolean writeToWAL) throws Exception {
        if (this.keyInMeta.isNull(row[this.keyIndex])) {
            throw new FieldException(Mapping.TupleMapping.KEY);
        }
        if (this.familyInMeta.isNull(row[this.familyIndex])) {
            throw new FieldException(Mapping.TupleMapping.FAMILY);
        }
        if (this.columnInMeta.isNull(row[this.columnIndex])) {
            throw new FieldException(Mapping.TupleMapping.COLUMN);
        }
        if (this.valueInMeta.isNull(row[this.valueIndex])) {
            throw new FieldException(Mapping.TupleMapping.VALUE);
        }
        byte[] encodedKey = bu.encodeKeyValue(row[this.keyIndex], this.keyInMeta, this.keyType);
        HBasePut put = hBaseTableWriteOperationManager.createPut(encodedKey);
        String columnFamily = this.familyInMeta.getString(row[this.familyIndex]);
        boolean binaryColName = false;
        String columnName = this.columnInMeta.getString(row[this.columnIndex]);
        if (columnName.startsWith("@@@binary@@@")) {
            columnName = columnName.replace("@@@binary@@@", "");
            binaryColName = true;
        }
        byte[] encodedValue = this.valueMeta.encodeColumnValue(row[this.valueIndex], this.valueInMeta);
        put.addColumn(columnFamily, columnName, binaryColName, encodedValue);
        if (this.visibilityIndex >= 0 && !this.visibilityInMeta.isNull(row[this.visibilityIndex])) {
            byte[] encodedVisibility = this.visibilityMeta.encodeColumnValue(row[this.visibilityIndex], this.visibilityInMeta);
            put.addColumn(columnFamily, "Visibility", false, encodedVisibility);
        }
        put.setWriteToWAL(writeToWAL);
        return put;
    }

    public static class FieldException
    extends Exception {
        public Mapping.TupleMapping field;

        public FieldException(Mapping.TupleMapping field) {
            this.field = field;
        }

        public String getFieldString() {
            return this.field.toString();
        }
    }
}

