/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.output;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.pentaho.big.data.kettle.plugins.hbase.output.HBaseOutputMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.table.HBasePut;
import org.pentaho.hadoop.shim.api.hbase.table.HBaseTableWriteOperationManager;

public class HBaseOutputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static HBasePut initializeNewPut(RowMetaInterface inRowMeta, int keyIndex, Object[] kettleRow, Mapping tableMapping, ByteConversionUtil bu, HBaseTableWriteOperationManager hBaseTableWriteOperationManager, boolean writeToWAL) throws Exception {
        ValueMetaInterface keyvm = inRowMeta.getValueMeta(keyIndex);
        if (keyvm.isNull(kettleRow[keyIndex])) {
            return null;
        }
        byte[] encodedKey = bu.encodeKeyValue(kettleRow[keyIndex], keyvm, tableMapping.getKeyType());
        HBasePut hBaseTablePut = hBaseTableWriteOperationManager.createPut(encodedKey);
        hBaseTablePut.setWriteToWAL(writeToWAL);
        return hBaseTablePut;
    }

    public static void addColumnsToPut(RowMetaInterface inRowMeta, Object[] kettleRow, int keyIndex, Map<String, HBaseValueMetaInterface> columnsMappedByAlias, HBasePut hBasePut, ByteConversionUtil bu) throws KettleException {
        for (int i = 0; i < inRowMeta.size(); ++i) {
            ValueMetaInterface current = inRowMeta.getValueMeta(i);
            if (i == keyIndex || current.isNull(kettleRow[i])) continue;
            HBaseValueMetaInterface hbaseColMeta = columnsMappedByAlias.get(current.getName());
            String columnFamily = hbaseColMeta.getColumnFamily();
            String columnName = hbaseColMeta.getColumnName();
            boolean binaryColName = false;
            if (columnName.startsWith("@@@binary@@@")) {
                columnName = columnName.replace("@@@binary@@@", "");
                binaryColName = true;
            }
            byte[] encoded = hbaseColMeta.encodeColumnValue(kettleRow[i], current);
            try {
                hBasePut.addColumn(columnFamily, columnName, binaryColName, encoded);
                continue;
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToAddColumnToTargetTablePut", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!Const.isEmpty((String)pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }
}

