/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.ByteConversionUtil;
import org.pentaho.hadoop.shim.api.hbase.mapping.Mapping;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.hadoop.shim.api.hbase.meta.HBaseValueMetaInterfaceFactory;

public class HBaseRowToKettleTuple {
    protected List<Object[]> mDecodedTuples;
    protected int mKeyIndex = -1;
    protected int mFamilyIndex = -1;
    protected int mColNameIndex = -1;
    protected int mValueIndex = -1;
    protected int mTimestampIndex = -1;
    protected List<byte[]> mUserSpecifiedFamilies;
    protected List<String> mUserSpecifiedFamiliesHumanReadable;
    protected List<HBaseValueMetaInterface> mTupleColsFromAliasMap;
    protected ByteConversionUtil mBytesUtil;

    public HBaseRowToKettleTuple(ByteConversionUtil bytesUtil) {
        if (bytesUtil == null) {
            throw new NullPointerException();
        }
        this.mBytesUtil = bytesUtil;
    }

    public void reset() {
        this.mDecodedTuples = null;
        this.mKeyIndex = -1;
        this.mFamilyIndex = -1;
        this.mColNameIndex = -1;
        this.mValueIndex = -1;
        this.mTimestampIndex = -1;
        this.mUserSpecifiedFamilies = null;
        this.mUserSpecifiedFamiliesHumanReadable = null;
        this.mTupleColsFromAliasMap = null;
    }

    public List<Object[]> hbaseRowToKettleTupleMode(HBaseValueMetaInterfaceFactory hBaseValueMetaInterfaceFactory, Object result, Mapping mapping, Map<String, HBaseValueMetaInterface> tupleColsMappedByAlias, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.mDecodedTuples == null) {
            this.mTupleColsFromAliasMap = new ArrayList<HBaseValueMetaInterface>();
            HBaseValueMetaInterface keyMeta = hBaseValueMetaInterfaceFactory.createHBaseValueMetaInterface(null, mapping.getKeyName(), "dummy", 5, 0, 0);
            this.mTupleColsFromAliasMap.add(keyMeta);
            for (Map.Entry<String, HBaseValueMetaInterface> entry : tupleColsMappedByAlias.entrySet()) {
                this.mTupleColsFromAliasMap.add(tupleColsMappedByAlias.get(entry.getValue()));
            }
        }
        return this.hbaseRowToKettleTupleMode(result, mapping, this.mTupleColsFromAliasMap, outputRowMeta);
    }

    public List<Object[]> hbaseRowToKettleTupleMode(Object result, Mapping mapping, List<HBaseValueMetaInterface> tupleCols, RowMetaInterface outputRowMeta) throws KettleException {
        if (this.mDecodedTuples == null) {
            this.mDecodedTuples = new ArrayList<Object[]>();
            this.mKeyIndex = outputRowMeta.indexOfValue(mapping.getKeyName());
            this.mFamilyIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.FAMILY.toString());
            this.mColNameIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.COLUMN.toString());
            this.mValueIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.VALUE.toString());
            this.mTimestampIndex = outputRowMeta.indexOfValue(Mapping.TupleMapping.TIMESTAMP.toString());
            if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
                String[] familiesS = mapping.getTupleFamiliesSplit();
                this.mUserSpecifiedFamilies = new ArrayList<byte[]>();
                this.mUserSpecifiedFamiliesHumanReadable = new ArrayList<String>();
                for (String family : familiesS) {
                    this.mUserSpecifiedFamiliesHumanReadable.add(family);
                    this.mUserSpecifiedFamilies.add(this.mBytesUtil.toBytes(family.trim()));
                }
            }
        } else {
            this.mDecodedTuples.clear();
        }
        byte[] rawKey = null;
        try {
            rawKey = (byte[])result.getClass().getMethod("getRow", new Class[0]).invoke(result, new Object[0]);
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        Object decodedKey = mapping.decodeKeyValue(rawKey);
        NavigableMap rowData = null;
        try {
            rowData = (NavigableMap)result.getClass().getMethod("getMap", new Class[0]).invoke(result, new Object[0]);
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        if (!Const.isEmpty((String)mapping.getTupleFamilies())) {
            int i = 0;
            for (byte[] family : this.mUserSpecifiedFamilies) {
                NavigableMap colMap = (NavigableMap)rowData.get(family);
                for (Map.Entry colMapEntry : colMap.entrySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMapEntry.getValue();
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.mKeyIndex != -1) {
                        newTuple[this.mKeyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.mTimestampIndex != -1) {
                        newTuple[this.mTimestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.mColNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMetaInterface colNameMeta = tupleCols.get(this.mColNameIndex);
                        newTuple[this.mColNameIndex] = decodedColName = colNameMeta.decodeColumnValue((byte[])colMapEntry.getKey());
                    }
                    if (this.mValueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMetaInterface colValueMeta = tupleCols.get(this.mValueIndex);
                        newTuple[this.mValueIndex] = decodedValue = colValueMeta.decodeColumnValue((byte[])mostRecentColVal.getValue());
                    }
                    if (this.mFamilyIndex != -1) {
                        newTuple[this.mFamilyIndex] = this.mUserSpecifiedFamiliesHumanReadable.get(i);
                    }
                    this.mDecodedTuples.add(newTuple);
                }
                ++i;
            }
        } else {
            for (Map.Entry rowDataEntry : rowData.entrySet()) {
                Object decodedFamily = null;
                if (this.mFamilyIndex != -1) {
                    HBaseValueMetaInterface colFamMeta = tupleCols.get(this.mFamilyIndex);
                    decodedFamily = colFamMeta.decodeColumnValue((byte[])rowDataEntry.getKey());
                }
                NavigableMap colMap = (NavigableMap)rowDataEntry.getValue();
                for (Map.Entry colMapEntry : colMap.entrySet()) {
                    NavigableMap valuesByTimestamp = (NavigableMap)colMapEntry.getValue();
                    Object[] newTuple = RowDataUtil.allocateRowData((int)outputRowMeta.size());
                    if (this.mKeyIndex != -1) {
                        newTuple[this.mKeyIndex] = decodedKey;
                    }
                    Map.Entry mostRecentColVal = valuesByTimestamp.lastEntry();
                    if (this.mTimestampIndex != -1) {
                        newTuple[this.mTimestampIndex] = mostRecentColVal.getKey();
                    }
                    if (this.mColNameIndex != -1) {
                        Object decodedColName;
                        HBaseValueMetaInterface colNameMeta = tupleCols.get(this.mColNameIndex);
                        newTuple[this.mColNameIndex] = decodedColName = colNameMeta.decodeColumnValue((byte[])colMapEntry.getKey());
                    }
                    if (this.mValueIndex != -1) {
                        Object decodedValue;
                        HBaseValueMetaInterface colValueMeta = tupleCols.get(this.mValueIndex);
                        newTuple[this.mValueIndex] = decodedValue = colValueMeta.decodeColumnValue((byte[])mostRecentColVal.getValue());
                    }
                    if (this.mFamilyIndex != -1) {
                        newTuple[this.mFamilyIndex] = decodedFamily;
                    }
                    this.mDecodedTuples.add(newTuple);
                }
            }
        }
        return this.mDecodedTuples;
    }
}

