/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase;

public class HbaseUtil {
    public static final String HBASE_NAMESPACE_DELIMITER = ":";
    public static final String HBASE_DEFAULT_NAMESPACE = "default";

    private HbaseUtil() {
    }

    public static String parseNamespaceFromTableName(String tableName) {
        return HbaseUtil.parseNamespaceFromTableName(tableName, HBASE_DEFAULT_NAMESPACE);
    }

    public static String parseNamespaceFromTableName(String tableName, String defaultNamespaceIfNoneSpecified) {
        String nameSpace = null;
        if (tableName.contains(HBASE_NAMESPACE_DELIMITER)) {
            nameSpace = tableName.substring(0, tableName.indexOf(HBASE_NAMESPACE_DELIMITER)).trim();
        }
        if (nameSpace == null || nameSpace.isEmpty()) {
            return defaultNamespaceIfNoneSpecified;
        }
        return nameSpace;
    }

    public static String parseQualifierFromTableName(String tableName) {
        if (tableName.contains(HBASE_NAMESPACE_DELIMITER)) {
            return tableName.substring(tableName.indexOf(HBASE_NAMESPACE_DELIMITER) + 1).trim();
        }
        return tableName.trim();
    }

    public static String expandTableName(String namespace, String qualifier) {
        if (namespace == null || namespace.isEmpty() || qualifier == null) {
            throw new IllegalArgumentException("Namespace must have a value, qualifier must not be null");
        }
        if (qualifier.indexOf(HBASE_NAMESPACE_DELIMITER) > -1) {
            return namespace + HBASE_NAMESPACE_DELIMITER + qualifier.substring(qualifier.indexOf(HBASE_NAMESPACE_DELIMITER) + 1);
        }
        return namespace + HBASE_NAMESPACE_DELIMITER + qualifier;
    }

    public static String expandTableName(String qualifier) {
        if (qualifier == null) {
            return "default:";
        }
        int pos = qualifier.indexOf(HBASE_NAMESPACE_DELIMITER);
        if (pos > 0) {
            return qualifier;
        }
        if (pos == 0) {
            return HBASE_DEFAULT_NAMESPACE + qualifier;
        }
        return "default:" + qualifier;
    }

    public static String expandLegacyTableNameOnLoad(String qualifier) {
        if (qualifier == null) {
            return HbaseUtil.expandTableName("");
        }
        int pos = Math.min(HbaseUtil.positionOfString(qualifier, "${"), HbaseUtil.positionOfString(qualifier, "%%"));
        if (pos == qualifier.length()) {
            return HbaseUtil.expandTableName(qualifier);
        }
        int delimPos = qualifier.indexOf(HBASE_NAMESPACE_DELIMITER);
        if (delimPos > -1 && delimPos < pos) {
            return HbaseUtil.expandTableName(qualifier);
        }
        return qualifier;
    }

    private static int positionOfString(String target, String search) {
        int pos = target.indexOf(search);
        if (pos == -1) {
            return target.length();
        }
        return pos;
    }
}

