/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.pentaho.di.core.util.HttpClientManager;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class ProxyServlet
extends ServletBase {
    private static final long serialVersionUID = 4680027723733552639L;
    private static final String TRUST_USER_PARAM = "_TRUST_USER_";
    private static final String TRUST_LOCALE_OVERRIDE_PARAM = "_TRUST_LOCALE_OVERRIDE_";
    private static final Log logger = LogFactory.getLog(ProxyServlet.class);
    private String proxyURL = null;
    private boolean isLocaleOverrideEnabled = true;
    private String errorURL = null;

    @Override
    public Log getLogger() {
        return logger;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.proxyURL = servletConfig.getInitParameter("ProxyURL");
        if (this.proxyURL == null) {
            this.error(Messages.getInstance().getString("ProxyServlet.ERROR_0001_NO_PROXY_URL_SPECIFIED"));
        } else {
            try {
                URL url = new URL(this.proxyURL.trim());
                this.info(Messages.getInstance().getString("ProxyServlet.INFO_0001_URL_SELECTED", new Object[]{url.toExternalForm()}));
            }
            catch (Throwable t) {
                this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0002_INVALID_URL", new Object[]{this.proxyURL}));
                this.proxyURL = null;
            }
        }
        String localeOverrideEnabledStr = servletConfig.getInitParameter("LocaleOverrideEnabled");
        if (StringUtils.isNotEmpty((String)localeOverrideEnabledStr)) {
            this.isLocaleOverrideEnabled = localeOverrideEnabledStr.equalsIgnoreCase("true");
        }
        this.errorURL = servletConfig.getInitParameter("ErrorURL");
        super.init(servletConfig);
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public String getErrorURL() {
        return this.errorURL;
    }

    public boolean isLocaleOverrideEnabled() {
        return this.isLocaleOverrideEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProxy(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.proxyURL == null) {
            return;
        }
        PentahoSystem.systemEntryPoint();
        try {
            String userName;
            IPentahoSession userSession = this.getPentahoSession(request);
            String string = userName = userSession != null ? userSession.getName() : null;
            if (StringUtils.isEmpty((String)userName) && StringUtils.isNotBlank((String)this.errorURL)) {
                response.sendRedirect(this.errorURL);
                return;
            }
            URI requestUri = this.buildProxiedUri(request, userName);
            this.doProxyCore(requestUri, response);
        }
        catch (URISyntaxException e) {
            this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0006_URI_SYNTAX_EXCEPTION", new Object[]{e.getMessage()}));
            e.printStackTrace();
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected URI buildProxiedUri(HttpServletRequest request, String userName) throws URISyntaxException {
        String baseUri = this.proxyURL + request.getServletPath();
        URIBuilder uriBuilder = new URIBuilder(baseUri);
        List<BasicNameValuePair> queryParams = uriBuilder.isQueryEmpty() ? new ArrayList() : uriBuilder.getQueryParams();
        queryParams.removeIf(pair -> pair.getName().equals(TRUST_USER_PARAM));
        Map paramMap = request.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            for (String element : (String[])entry.getValue()) {
                queryParams.add(new BasicNameValuePair((String)entry.getKey(), element));
            }
        }
        if (StringUtils.isNotEmpty((String)userName)) {
            queryParams.add(new BasicNameValuePair(TRUST_USER_PARAM, userName));
            if (this.isLocaleOverrideEnabled) {
                queryParams.add(new BasicNameValuePair(TRUST_LOCALE_OVERRIDE_PARAM, LocaleHelper.getLocale().toString()));
            }
        }
        uriBuilder.setParameters(queryParams);
        this.debug(Messages.getInstance().getString("ProxyServlet.DEBUG_0001_OUTPUT_URL", new Object[]{uriBuilder.toString()}));
        return uriBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProxyCore(URI requestUri, HttpServletResponse response) {
        HttpPost method = new HttpPost(requestUri);
        CloseableHttpClient client = HttpClientManager.getInstance().createDefaultClient();
        try {
            int inCnt;
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            StatusLine statusLine = httpResponse.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0003_REMOTE_HTTP_CALL_FAILED", new Object[]{statusLine.toString()}));
                return;
            }
            this.setHeader("Content-Type", (HttpRequestBase)method, response);
            this.setHeader("Content-Length", (HttpRequestBase)method, response);
            InputStream inStr = httpResponse.getEntity().getContent();
            ServletOutputStream outStr = response.getOutputStream();
            byte[] buf = new byte[2048];
            while (-1 != (inCnt = inStr.read(buf))) {
                outStr.write(buf, 0, inCnt);
            }
        }
        catch (IOException e) {
            this.error(Messages.getInstance().getErrorString("ProxyServlet.ERROR_0005_TRANSPORT_FAILURE"), e);
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
    }

    private void setHeader(String headerStr, HttpRequestBase method, HttpServletResponse response) {
        Header header = method.getHeaders(headerStr)[0];
        if (header != null) {
            response.setHeader(headerStr, header.getValue());
        }
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }
}

