/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.impl.StandardSerializationPolicy;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.gwt.rpc.AbstractGwtRpc;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.gwt.rpc.support.GwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;

public abstract class AbstractGwtRpcProxyServlet
extends RemoteServiceServlet {
    private static final Log logger = LogFactory.getLog(AbstractGwtRpcProxyServlet.class);
    @NonNull
    private final IGwtRpcSerializationPolicyCache serializationPolicyCache;

    protected AbstractGwtRpcProxyServlet() {
        this(null);
    }

    protected AbstractGwtRpcProxyServlet(@Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        this.serializationPolicyCache = serializationPolicyCache != null ? serializationPolicyCache : new GwtRpcSerializationPolicyCache();
    }

    @NonNull
    public IGwtRpcSerializationPolicyCache getSerializationPolicyCache() {
        return this.serializationPolicyCache;
    }

    protected void doUnexpectedFailure(Throwable e) {
        super.doUnexpectedFailure(e);
        logger.error((Object)e);
    }

    @NonNull
    protected abstract AbstractGwtRpc getRpc(@NonNull HttpServletRequest var1);

    protected String readContent(HttpServletRequest httpRequest) {
        return this.getRpc(httpRequest).getRequestPayload();
    }

    public String processCall(String requestPayload) throws SerializationException {
        this.checkPermutationStrongName();
        try {
            return this.getRpc(this.getThreadLocalRequest()).invoke();
        }
        catch (GwtRpcProxyException ex) {
            return RPC.encodeResponseForFailure(null, (Throwable)ex, (SerializationPolicy)AbstractGwtRpcProxyServlet.getBasicSerializationPolicy());
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        throw new UnsupportedOperationException("Class is not being used as SerializationPolicyProvider");
    }

    @NonNull
    static StandardSerializationPolicy getBasicSerializationPolicy() {
        HashMap<Class<GwtRpcProxyException>, Boolean> whitelist = new HashMap<Class<GwtRpcProxyException>, Boolean>();
        whitelist.put(GwtRpcProxyException.class, Boolean.TRUE);
        HashMap obfuscatedTypeIds = new HashMap();
        return new StandardSerializationPolicy(whitelist, whitelist, obfuscatedTypeIds);
    }
}

