/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.security;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.web.http.PreAuthenticatedSessionHolder;
import org.springframework.security.core.context.SecurityContextHolder;

public class PreAuthenticatedFilter
implements Filter {
    private static Log log = LogFactory.getLog(PreAuthenticatedFilter.class);
    private PreAuthenticatedSessionHolder preAuthHolder;
    private static final String ASSO_KEY = "asso";

    public PreAuthenticatedFilter(PreAuthenticatedSessionHolder sessionHolder) {
        this.preAuthHolder = sessionHolder;
    }

    public void destroy() {
        this.preAuthHolder.close();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            String assoKey = servletRequest.getParameter(ASSO_KEY);
            if (StringUtils.isEmpty((String)assoKey)) {
                return;
            }
            this.preAuthHolder.restoreSession(assoKey);
        }
        catch (Exception e) {
            log.error((Object)e);
            SecurityContextHolder.getContext().setAuthentication(null);
            PentahoSessionHolder.removeSession();
        }
        finally {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

