/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository2.userroledao.jackrabbit.security.DefaultPentahoPasswordEncoder;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.web.http.api.resources.LocalizedLogicalRoleName;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignment;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignments;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.SystemRolesMap;
import org.pentaho.platform.web.http.api.resources.User;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class UserRoleDaoService {
    private IUserRoleDao roleDao;
    private IAuthorizationPolicy policy;
    private IRoleAuthorizationPolicyRoleBindingDao roleBindingDao;
    private static final String PASS_VALIDATION_ERROR_WRONG_PASS = "UserRoleDaoService.PassValidationError_WrongPass";
    public static final String PUC_USER_PASSWORD_LENGTH = "PUC_USER_PASSWORD_LENGTH";
    public static final String PUC_USER_PASSWORD_REQUIRE_SPECIAL_CHARACTER = "PUC_USER_PASSWORD_REQUIRE_SPECIAL_CHARACTER";
    private ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);

    public UserListWrapper getUsers() throws Exception {
        return new UserListWrapper(this.getRoleDao().getUsers());
    }

    public RoleListWrapper getRolesForUser(String user) throws UncategorizedUserRoleDaoException {
        if (this.canAdminister()) {
            ITenant tenant = TenantUtils.getCurrentTenant();
            return new RoleListWrapper(this.getRoleDao().getUserRoles(tenant, user));
        }
        throw new SecurityException();
    }

    public void assignRolesToUser(String userName, String roleNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        ITenant tenant;
        HashSet<String> assignedRoles;
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            assignedRoles = new HashSet<String>();
            tenant = TenantUtils.getCurrentTenant();
            for (IPentahoRole pentahoRole : this.getRoleDao().getUserRoles(tenant, userName)) {
                assignedRoles.add(pentahoRole.getName());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedRoles.add(tokenizer.nextToken());
            }
        } else {
            throw new SecurityException();
        }
        this.getRoleDao().setUserRoles(tenant, userName, assignedRoles.toArray(new String[assignedRoles.size()]));
    }

    public void removeRolesFromUser(String userName, String roleNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        ITenant tenant;
        HashSet<String> assignedRoles;
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            assignedRoles = new HashSet<String>();
            tenant = TenantUtils.getCurrentTenant();
            for (IPentahoRole pentahoRole : this.getRoleDao().getUserRoles(tenant, userName)) {
                assignedRoles.add(pentahoRole.getName());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedRoles.remove(tokenizer.nextToken());
            }
        } else {
            throw new SecurityException();
        }
        this.getRoleDao().setUserRoles(tenant, userName, assignedRoles.toArray(new String[assignedRoles.size()]));
    }

    public void createRole(String roleName) throws Exception {
        if (this.canAdminister()) {
            if (!this.strNotEmpty(roleName)) {
                throw new ValidationFailedException();
            }
        } else {
            throw new SecurityException();
        }
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        roleDao.createRole(null, roleName, "", new String[0]);
    }

    public RoleListWrapper getRoles() throws UncategorizedUserRoleDaoException {
        return new RoleListWrapper(this.getRoleDao().getRoles());
    }

    public UserListWrapper getRoleMembers(String roleName) throws UncategorizedUserRoleDaoException, SecurityException {
        if (this.canAdminister()) {
            return new UserListWrapper(this.getRoleDao().getRoleMembers(TenantUtils.getCurrentTenant(), roleName));
        }
        throw new SecurityException();
    }

    private boolean containsReservedChars(String username) {
        StringBuffer reservedChars = new FileService().doGetReservedChars();
        return StringUtils.containsAny((CharSequence)username, (CharSequence)reservedChars);
    }

    private boolean strNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    private boolean userValid(User user) {
        String name = user.getUserName();
        String pass = user.getPassword();
        boolean nameValid = this.strNotEmpty(name) && !this.containsReservedChars(name);
        boolean passValid = this.strNotEmpty(pass);
        return nameValid && passValid;
    }

    private String decode(String toDecode) {
        try {
            return URLDecoder.decode(toDecode.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return toDecode;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createUser(User user) throws Exception {
        if (!this.canAdminister()) throw new SecurityException(Messages.getInstance().getString(PASS_VALIDATION_ERROR_WRONG_PASS));
        if (!this.userValid(user)) throw new ValidationFailedException();
        String userName = this.decode(user.getUserName());
        String password = user.getPassword();
        ValidationFailedException exception = this.validatePasswordFormat(password);
        if (exception != null) {
            throw exception;
        }
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        roleDao.createUser(null, userName, password, "", new String[0]);
    }

    private boolean inputValid(String userName, String newPass, String oldPass) {
        boolean userNameValid = userName != null && userName.length() > 0;
        boolean newPassValid = newPass != null && newPass.length() > 0;
        boolean oldPassValid = oldPass != null && oldPass.length() > 0;
        return userNameValid && newPassValid && oldPassValid;
    }

    private ValidationFailedException validatePasswordFormat(String password) {
        int reqPassLength = 0;
        boolean isSpecCharReq = false;
        IConfiguration securityConfig = this.systemConfig.getConfiguration("security");
        try {
            String isSpecCharReqStr;
            String reqPassLengthStr = securityConfig.getProperties().getProperty(PUC_USER_PASSWORD_LENGTH);
            if (!StringUtils.isEmpty((CharSequence)reqPassLengthStr)) {
                reqPassLength = Integer.parseInt(reqPassLengthStr);
            }
            if (!StringUtils.isEmpty((CharSequence)(isSpecCharReqStr = securityConfig.getProperties().getProperty(PUC_USER_PASSWORD_REQUIRE_SPECIAL_CHARACTER)))) {
                isSpecCharReq = Boolean.parseBoolean(isSpecCharReqStr);
            }
        }
        catch (IOException e) {
            return new ValidationFailedException(Messages.getInstance().getString("UserRoleDaoService.PassValidationError_ReadingSecProperties"));
        }
        String PASSWORD_SPEC_CHAR_PATTERN = "((?=.*[@#$%!]).{0,100})";
        String errorMsg = "New password must: ";
        ArrayList<String> validationCriteria = new ArrayList<String>();
        if (reqPassLength > 0) {
            validationCriteria.add(Messages.getInstance().getString("UserRoleDaoService.PassValidationError_Length", new Object[]{Integer.toString(reqPassLength)}));
        }
        if (isSpecCharReq) {
            validationCriteria.add(Messages.getInstance().getString("UserRoleDaoService.PassValidationError_SpecChar"));
        }
        errorMsg = errorMsg + String.join((CharSequence)", ", validationCriteria) + ".";
        if (password.length() < reqPassLength || isSpecCharReq && !password.matches("((?=.*[@#$%!]).{0,100})")) {
            ValidationFailedException exception = new ValidationFailedException(errorMsg);
            return exception;
        }
        return null;
    }

    private boolean credentialValid(IPentahoUser pentahoUser, String oldPass) {
        if (pentahoUser != null) {
            DefaultPentahoPasswordEncoder encoder = new DefaultPentahoPasswordEncoder();
            return encoder.isPasswordValid(pentahoUser.getPassword(), oldPass, null);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changeUserPassword(final String userName, final String newPass, String oldPass) throws Exception {
        if (!this.inputValid(userName, newPass, oldPass)) throw new ValidationFailedException();
        ValidationFailedException exception = this.validatePasswordFormat(newPass);
        if (exception != null) {
            throw exception;
        }
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        if (!this.canAdminister() && (null == pentahoSession || !userName.equals(pentahoSession.getName()))) throw new SecurityException(Messages.getInstance().getString(PASS_VALIDATION_ERROR_WRONG_PASS));
        final IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)pentahoSession);
        IPentahoUser pentahoUser = roleDao.getUser(null, userName);
        if (!this.credentialValid(pentahoUser, oldPass)) {
            throw new SecurityException(Messages.getInstance().getString(PASS_VALIDATION_ERROR_WRONG_PASS));
        }
        SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                roleDao.setPassword(null, userName, newPass);
                return null;
            }
        });
    }

    public void deleteUsers(String userNames) throws NotFoundException, UncategorizedUserRoleDaoException, SecurityException {
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
            while (tokenizer.hasMoreTokens()) {
                IPentahoUser user = this.getRoleDao().getUser(null, tokenizer.nextToken());
                if (user == null) continue;
                this.getRoleDao().deleteUser(user);
            }
        } else {
            throw new SecurityException();
        }
    }

    public void deleteRoles(String roleNames) throws SecurityException, UncategorizedUserRoleDaoException {
        if (this.canAdminister()) {
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            while (tokenizer.hasMoreTokens()) {
                IPentahoRole role = this.getRoleDao().getRole(null, tokenizer.nextToken());
                if (role == null) continue;
                this.getRoleDao().deleteRole(role);
            }
        } else {
            throw new SecurityException();
        }
    }

    public SystemRolesMap getRoleBindingStruct(String locale) throws SecurityException {
        if (this.canAdminister()) {
            RoleBindingStruct roleBindingStruct = this.getRoleBindingDao().getRoleBindingStruct(locale);
            SystemRolesMap systemRolesMap = new SystemRolesMap();
            for (Map.Entry localalizeNameEntry : roleBindingStruct.logicalRoleNameMap.entrySet()) {
                systemRolesMap.getLocalizedRoleNames().add(new LocalizedLogicalRoleName((String)localalizeNameEntry.getKey(), (String)localalizeNameEntry.getValue()));
            }
            for (Map.Entry logicalRoleAssignments : roleBindingStruct.bindingMap.entrySet()) {
                systemRolesMap.getAssignments().add(new LogicalRoleAssignment((String)logicalRoleAssignments.getKey(), (List)logicalRoleAssignments.getValue(), roleBindingStruct.immutableRoles.contains(logicalRoleAssignments.getKey())));
            }
            return systemRolesMap;
        }
        throw new SecurityException();
    }

    public void setLogicalRoles(LogicalRoleAssignments roleAssignments) throws SecurityException {
        if (this.canAdminister()) {
            for (LogicalRoleAssignment roleAssignment : roleAssignments.getAssignments()) {
                this.getRoleBindingDao().setRoleBindings(roleAssignment.getRoleName(), roleAssignment.getLogicalRoles());
            }
        } else {
            throw new SecurityException();
        }
    }

    public void updatePassword(User user, String administratorPassword) throws ValidationFailedException {
        IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
        AuthenticationProvider authenticator = (AuthenticationProvider)PentahoSystem.get(AuthenticationProvider.class, (IPentahoSession)pentahoSession);
        if (authenticator == null) {
            throw new SecurityException("Authentication Provider not found, can not re-authenticate logged-in user");
        }
        try {
            Authentication authentication = authenticator.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)pentahoSession.getName(), (Object)administratorPassword));
            if (!authentication.isAuthenticated()) {
                throw new SecurityException("Logged-in user re-authentication failed");
            }
            this.updatePassword(user);
        }
        catch (AuthenticationException e) {
            throw new SecurityException("Logged-in user re-authentication failed", e);
        }
        catch (ValidationFailedException e) {
            throw e;
        }
    }

    public void updatePassword(User user) throws ValidationFailedException {
        IUserRoleDao roleDao;
        String password;
        String userName;
        if (this.canAdminister()) {
            userName = this.decode(user.getUserName());
            password = user.getPassword();
            ValidationFailedException exception = this.validatePasswordFormat(password);
            if (exception != null) {
                throw exception;
            }
            roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            IPentahoUser puser = roleDao.getUser(null, userName);
            if (puser == null) {
                throw new SecurityException("User not found");
            }
        } else {
            throw new SecurityException("Logged-in user is not authorized to change password");
        }
        roleDao.setPassword(null, userName, password);
    }

    private boolean canAdminister() {
        return this.getPolicy().isAllowed("org.pentaho.repository.read") && this.getPolicy().isAllowed("org.pentaho.repository.create") && this.getPolicy().isAllowed("org.pentaho.security.administerSecurity");
    }

    private IRoleAuthorizationPolicyRoleBindingDao getRoleBindingDao() {
        if (this.roleBindingDao == null) {
            this.roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
        }
        return this.roleBindingDao;
    }

    private IAuthorizationPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    private IUserRoleDao getRoleDao() {
        if (this.roleDao == null) {
            this.roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
        }
        return this.roleDao;
    }

    @VisibleForTesting
    protected void setSystemConfig(ISystemConfig systemConfig) {
        this.systemConfig = systemConfig;
    }

    public static class ValidationFailedException
    extends Exception {
        public ValidationFailedException() {
        }

        public ValidationFailedException(String message) {
            super(message);
        }
    }
}

