/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.google.gwt.user.server.Base64Utils;
import com.sun.jersey.api.NotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.engine.security.userroledao.UncategorizedUserRoleDaoException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantManager;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.ChangePasswordUser;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignments;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.SystemRolesMap;
import org.pentaho.platform.web.http.api.resources.User;
import org.pentaho.platform.web.http.api.resources.UserChangePasswordDTO;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;
import org.pentaho.platform.web.http.api.resources.services.UserRoleDaoService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

@Path(value="/userroledao/")
public class UserRoleDaoResource
extends AbstractJaxRSResource {
    private static final String PUC_VALIDATION_ERROR_MESSAGE = "PUC_VALIDATION_ERROR_MESSAGE";
    private IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = null;
    private ITenantManager tenantManager = null;
    private final UserRoleDaoService userRoleDaoService;
    private ArrayList<String> systemRoles;
    private String adminRole;
    private static final Log logger = LogFactory.getLog(UserRoleDaoResource.class);

    public UserRoleDaoResource() {
        this((IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class), (ITenantManager)PentahoSystem.get(ITenantManager.class), (ArrayList)PentahoSystem.get(ArrayList.class, (String)"singleTenantSystemAuthorities", (IPentahoSession)PentahoSessionHolder.getSession()), (String)PentahoSystem.get(String.class, (String)"singleTenantAdminAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession()), new UserRoleDaoService());
    }

    public UserRoleDaoResource(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, ITenantManager tenantMgr, ArrayList<String> systemRoles, String adminRole) {
        this(roleBindingDao, tenantMgr, systemRoles, adminRole, new UserRoleDaoService());
    }

    public UserRoleDaoResource(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, ITenantManager tenantMgr, ArrayList<String> systemRoles, String adminRole, UserRoleDaoService service) {
        if (roleBindingDao == null) {
            throw new IllegalArgumentException();
        }
        this.roleBindingDao = roleBindingDao;
        this.tenantManager = tenantMgr;
        this.systemRoles = systemRoles;
        this.adminRole = adminRole;
        this.userRoleDaoService = service;
    }

    @PUT
    @Path(value="/createUser")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created new user."), @ResponseCode(code=400, condition="Provided data has invalid format."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=412, condition="Unable to create user.")})
    public Response createUser(User user) {
        try {
            user.setPassword(this.b64DecodePassword(user.getPassword()));
            this.userRoleDaoService.createUser(user);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (UserRoleDaoService.ValidationFailedException e) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            response.header(PUC_VALIDATION_ERROR_MESSAGE, (Object)e.getMessage());
            throw new WebApplicationException(response.build());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/deleteUsers")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully deleted the list of users."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="Internal server error prevented the system from properly retrieving either the user or roles.")})
    public Response deleteUsers(@QueryParam(value="userNames") String userNames) {
        try {
            this.userRoleDaoService.deleteUsers(userNames);
            return Response.noContent().build();
        }
        catch (org.pentaho.platform.api.engine.security.userroledao.NotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @PUT
    @Path(value="/user")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully changed password."), @ResponseCode(code=400, condition="Provided data has invalid format."), @ResponseCode(code=403, condition="Provided user name or password is incorrect."), @ResponseCode(code=412, condition="An error occurred in the platform.")})
    public Response changeUserPassword(ChangePasswordUser user) {
        try {
            user.setNewPassword(this.b64DecodePassword(user.getNewPassword()));
            user.setOldPassword(this.b64DecodePassword(user.getOldPassword()));
            this.userRoleDaoService.changeUserPassword(user.getUserName(), user.getNewPassword(), user.getOldPassword());
        }
        catch (UserRoleDaoService.ValidationFailedException e) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            response.header(PUC_VALIDATION_ERROR_MESSAGE, (Object)e.getMessage());
            throw new WebApplicationException(response.build());
        }
        catch (SecurityException e) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN);
            response.header(PUC_VALIDATION_ERROR_MESSAGE, (Object)e.getMessage());
            throw new WebApplicationException(response.build());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return Response.noContent().build();
    }

    private String b64DecodePassword(String encodedPassword) {
        if (!StringUtils.isEmpty((String)encodedPassword) && encodedPassword.startsWith("ENC:")) {
            return new String(Base64Utils.fromBase64((String)encodedPassword.substring(4)), StandardCharsets.UTF_8);
        }
        return encodedPassword;
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returned the list of users."), @ResponseCode(code=500, condition="An error occurred in the platform while trying to access the list of users.")})
    public UserListWrapper getUsers() throws WebApplicationException {
        try {
            return this.userRoleDaoService.getUsers();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/userRoles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of roles."), @ResponseCode(code=500, condition="Invalid user parameter.")})
    public RoleListWrapper getRolesForUser(@QueryParam(value="userName") String user) throws Exception {
        try {
            return this.userRoleDaoService.getRolesForUser(user);
        }
        catch (UncategorizedUserRoleDaoException t) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="/assignRoleToUser")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully append the roles to the user."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="Internal server error prevented the system from properly retrieving either the user or roles.")})
    public Response assignRolesToUser(@QueryParam(value="userName") String userName, @QueryParam(value="roleNames") String roleNames) {
        try {
            this.userRoleDaoService.assignRolesToUser(userName, roleNames);
            if (userName.equals(this.getSession().getName())) {
                this.updateRolesForCurrentSession();
            }
            return Response.noContent().build();
        }
        catch (org.pentaho.platform.api.engine.security.userroledao.NotFoundException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @PUT
    @Path(value="/removeRoleFromUser")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully removed the roles from the user."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="Internal server error prevented the system from properly retrieving either the user or roles.")})
    public Response removeRolesFromUser(@QueryParam(value="userName") String userName, @QueryParam(value="roleNames") String roleNames) {
        try {
            this.userRoleDaoService.removeRolesFromUser(userName, roleNames);
            if (userName.equals(this.getSession().getName())) {
                this.updateRolesForCurrentSession();
            }
            return Response.noContent().build();
        }
        catch (org.pentaho.platform.api.engine.security.userroledao.NotFoundException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getLocalizedMessage()).build());
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build());
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getLocalizedMessage()).build());
        }
    }

    @PUT
    @Path(value="/createRole")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created new role."), @ResponseCode(code=400, condition="Provided data has invalid format."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=412, condition="Unable to create role objects.")})
    public Response createRole(@QueryParam(value="roleName") String roleName) {
        try {
            this.userRoleDaoService.createRole(roleName);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (UserRoleDaoService.ValidationFailedException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/deleteRoles")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully deleted the list of roles."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="The system was unable to delete the roles passed in.")})
    public Response deleteRoles(@QueryParam(value="roleNames") String roleNames) {
        try {
            this.userRoleDaoService.deleteRoles(roleNames);
            this.updateRolesForCurrentSession();
            return Response.noContent().build();
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/roles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of roles."), @ResponseCode(code=500, condition="The system was not able to return the list of roles.")})
    public RoleListWrapper getRoles() throws Exception {
        try {
            return this.userRoleDaoService.getRoles();
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/roleMembers")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of Users."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="The system was not able to return the list of users.")})
    public UserListWrapper getRoleMembers(@QueryParam(value="roleName") String roleName) throws Exception {
        try {
            return this.userRoleDaoService.getRoleMembers(roleName);
        }
        catch (UncategorizedUserRoleDaoException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @Path(value="/roleAssignments")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully applied the logical role assignment."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method.")})
    public Response setLogicalRoles(LogicalRoleAssignments roleAssignments) {
        try {
            this.userRoleDaoService.setLogicalRoles(roleAssignments);
            return Response.noContent().build();
        }
        catch (SecurityException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @GET
    @Path(value="/logicalRoleMap")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=403, condition="Only users with administrative privileges can access this method.")})
    public SystemRolesMap getRoleBindingStruct(@QueryParam(value="locale") String locale) {
        try {
            return this.userRoleDaoService.getRoleBindingStruct(locale);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    @PUT
    @Path(value="/assignAllRolesToUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignAllRolesToUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName) {
        IUserRoleDao roleDao = this.getUserRoleDao();
        HashSet<String> assignedRoles = new HashSet<String>();
        for (IPentahoRole pentahoRole : roleDao.getRoles(this.getTenant(tenantPath))) {
            assignedRoles.add(pentahoRole.getName());
        }
        roleDao.setUserRoles(this.getTenant(tenantPath), userName, assignedRoles.toArray(new String[0]));
        if (userName.equals(this.getSession().getName())) {
            this.updateRolesForCurrentSession();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/removeAllRolesFromUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeAllRolesFromUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = this.getUserRoleDao();
                roleDao.setUserRoles(this.getTenant(tenantPath), userName, new String[0]);
                if (userName.equals(this.getSession().getName())) {
                    this.updateRolesForCurrentSession();
                }
                return Response.noContent().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/assignUserToRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignUserToRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userNames") String userNames, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            IUserRoleDao roleDao = this.getUserRoleDao();
            StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
            HashSet<String> assignedUserNames = new HashSet<String>();
            for (IPentahoUser pentahoUser : roleDao.getRoleMembers(this.getTenant(tenantPath), roleName)) {
                assignedUserNames.add(pentahoUser.getUsername());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedUserNames.add(tokenizer.nextToken());
            }
            try {
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
                if (assignedUserNames.contains(this.getSession().getName())) {
                    this.updateRolesForCurrentSession();
                }
                return Response.noContent().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/removeUserFromRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeUserFromRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userNames") String userNames, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = this.getUserRoleDao();
                StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
                HashSet<String> assignedUserNames = new HashSet<String>();
                for (IPentahoUser pentahoUser : roleDao.getRoleMembers(this.getTenant(tenantPath), roleName)) {
                    assignedUserNames.add(pentahoUser.getUsername());
                }
                while (tokenizer.hasMoreTokens()) {
                    assignedUserNames.remove(tokenizer.nextToken());
                }
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
                if (assignedUserNames.contains(this.getSession().getName())) {
                    this.updateRolesForCurrentSession();
                }
                return Response.noContent().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/assignAllUsersToRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignAllUsersToRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) {
        IUserRoleDao roleDao = this.getUserRoleDao();
        HashSet<String> assignedUserNames = new HashSet<String>();
        for (IPentahoUser pentahoUser : roleDao.getUsers(this.getTenant(tenantPath))) {
            assignedUserNames.add(pentahoUser.getUsername());
        }
        roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
        if (assignedUserNames.contains(this.getSession().getName())) {
            this.updateRolesForCurrentSession();
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/removeAllUsersFromRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeAllUsersFromRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = this.getUserRoleDao();
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, new String[0]);
                this.updateRolesForCurrentSession();
                return Response.noContent().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/updatePassword")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully deleted the list of users."), @ResponseCode(code=403, condition="Only users with administrative privileges can access this method."), @ResponseCode(code=500, condition="Internal server error prevented the system from properly retrieving either the user or roles.")})
    public Response updatePassword(UserChangePasswordDTO user) {
        try {
            user.setPassword(this.b64DecodePassword(user.getPassword()));
            user.setAdministratorPassword(this.b64DecodePassword(user.getAdministratorPassword()));
            this.userRoleDaoService.updatePassword(user, user.getAdministratorPassword());
        }
        catch (SecurityException e) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN);
            response.header(PUC_VALIDATION_ERROR_MESSAGE, (Object)e.getMessage());
            throw new WebApplicationException(response.build());
        }
        catch (UserRoleDaoService.ValidationFailedException e) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST);
            response.header(PUC_VALIDATION_ERROR_MESSAGE, (Object)e.getMessage());
            throw new WebApplicationException(response.build());
        }
        return Response.noContent().build();
    }

    protected ITenant getTenant(String tenantId) throws NotFoundException {
        ITenant tenant = null;
        if (tenantId != null) {
            tenant = this.tenantManager.getTenant(tenantId);
            if (tenant == null) {
                throw new NotFoundException("Tenant not found.");
            }
        } else {
            IPentahoSession session = this.getSession();
            String tenantPath = (String)session.getAttribute("org.pentaho.tenantId");
            if (tenantPath != null) {
                tenant = new Tenant(tenantPath, Boolean.valueOf(true));
            }
        }
        return tenant;
    }

    private HashSet<String> tokenToString(String tokenString) {
        StringTokenizer tokenizer = new StringTokenizer(tokenString, "\t");
        HashSet<String> result = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private Response processErrorResponse(String errMessage) {
        return Response.ok((Object)errMessage).build();
    }

    protected boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }

    protected void updateRolesForCurrentSession() {
        List<String> userRoles = this.userRoleDaoService.getRolesForUser(this.getSession().getName()).getRoles();
        ArrayList authorities = new ArrayList();
        userRoles.forEach(role -> authorities.add(new SimpleGrantedAuthority(role)));
        this.getSession().setAttribute("roles", authorities);
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected IUserRoleDao getUserRoleDao() {
        return (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)this.getSession());
    }
}

