/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.services.FileService;
import org.pentaho.platform.web.http.api.resources.utils.FileUtils;

@Path(value="/repo/dirs/")
public class DirectoryResource
extends AbstractJaxRSResource {
    protected FileService fileService = new FileService();

    public DirectoryResource() {
    }

    public DirectoryResource(HttpServletResponse httpServletResponse) {
        this();
        this.httpServletResponse = httpServletResponse;
    }

    @PUT
    @Path(value="{pathId : .+}")
    @Consumes(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully created folder."), @ResponseCode(code=403, condition="Forbidden."), @ResponseCode(code=409, condition="Path already exists."), @ResponseCode(code=500, condition="Server Error.")})
    public Response createDirs(@PathParam(value="pathId") String pathId) {
        try {
            if (FileUtils.isRootLevelPath(FileUtils.idToPath(pathId))) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"couldNotCreateRootLevelFolder").build();
            }
            if (this.fileService.doCreateDirSafe(pathId)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"couldNotCreateFolderDuplicate").build();
        }
        catch (FileService.InvalidNameException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"containsIllegalCharacters").build();
        }
        catch (Throwable t) {
            return Response.serverError().entity((Object)"").build();
        }
    }

    @GET
    @Path(value="{pathId : .+}/isVisible")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns a boolean value, either true or false")})
    public Response isDirVisible(@PathParam(value="pathId") String pathId) {
        try {
            if (this.fileService.doesExist(pathId) && this.fileService.isFolder(pathId)) {
                return Response.ok((Object)String.valueOf(this.fileService.doGetIsVisible(pathId))).build();
            }
            return Response.ok((Object)"false").build();
        }
        catch (Exception e) {
            return Response.ok((Object)"false").build();
        }
    }

    @GET
    @Path(value="{pathId : .+}/defaultLocation")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns a default open/save location")})
    public Response getDefaultLocation(@PathParam(value="pathId") String pathId) {
        try {
            return Response.ok((Object)String.valueOf(this.fileService.doGetDefaultLocation(pathId))).build();
        }
        catch (Exception e) {
            return Response.ok((Object)pathId).build();
        }
    }
}

