/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.platform.engine.services.solution.SimpleParameterSetter;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.api.resources.XactionUtil;

public class ActionSequenceContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 458870144807597675L;
    private static final String TEXT_HTML = "text/html";
    private IParameterProvider requestParameters;
    private IParameterProvider pathParameters;
    private String path = null;
    private String contentType = null;

    public Log getLogger() {
        return LogFactory.getLog(ActionSequenceContentGenerator.class);
    }

    public void createContent(OutputStream outputStream) throws Exception {
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        IUnifiedRepository unifiedRepository;
        RepositoryFile file;
        String buffer;
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        if (requestParams != null && requestParams.getStringParameter("path", null) != null) {
            this.path = requestParams.getStringParameter("path", "");
        } else if (pathParams != null && pathParams.getStringParameter("path", null) != null) {
            this.path = URLDecoder.decode(pathParams.getStringParameter("path", ""), "UTF-8");
        }
        if (requestParams != null && requestParams.getStringParameter("contentType", null) != null) {
            this.contentType = requestParams.getStringParameter("contentType", TEXT_HTML);
        } else if (pathParams != null && pathParams.getStringParameter("contentType", null) != null) {
            this.contentType = pathParams.getStringParameter("contentType", TEXT_HTML);
        }
        if (this.path != null && this.path.length() > 0 && (buffer = XactionUtil.execute(this.contentType, file = (unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null)).getFile(this.path), httpRequest = (HttpServletRequest)pathParams.getParameter("httprequest"), httpResponse = (HttpServletResponse)pathParams.getParameter("httpresponse"), PentahoSessionHolder.getSession(), this.outputHandler.getMimeTypeListener())) != null && buffer.trim().length() > 0) {
            outputStream.write(buffer.getBytes(LocaleHelper.getSystemEncoding()));
        }
    }

    public Map<String, IParameterProvider> getParameterProviders() {
        return this.parameterProviders;
    }

    private IParameterProvider getRequestParameters() {
        if (this.requestParameters != null) {
            return this.requestParameters;
        }
        if (this.parameterProviders == null) {
            return new SimpleParameterProvider();
        }
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        SimpleParameterSetter parameters = new SimpleParameterSetter();
        Iterator requestParamIterator = requestParams.getParameterNames();
        while (requestParamIterator.hasNext()) {
            String param = (String)requestParamIterator.next();
            parameters.setParameter(param, requestParams.getParameter(param));
        }
        this.requestParameters = parameters;
        return parameters;
    }

    public IParameterProvider getPathParameters() {
        if (this.pathParameters != null) {
            return this.pathParameters;
        }
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        SimpleParameterSetter parameters = new SimpleParameterSetter();
        Iterator pathParamIterator = pathParams.getParameterNames();
        while (pathParamIterator.hasNext()) {
            String param = (String)pathParamIterator.next();
            parameters.setParameter(param, pathParams.getParameter(param));
        }
        this.pathParameters = parameters;
        return parameters;
    }

    public String getMimeType() {
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        if (requestParams != null && requestParams.getStringParameter("contentType", null) != null) {
            this.contentType = requestParams.getStringParameter("contentType", TEXT_HTML);
        } else if (pathParams != null && pathParams.getStringParameter("contentType", null) != null) {
            this.contentType = pathParams.getStringParameter("contentType", TEXT_HTML);
        }
        return this.contentType;
    }
}

