/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc.spring.xml;

import java.util.Arrays;
import java.util.List;
import org.pentaho.platform.web.gwt.rpc.matcher.PluginGwtRpcRequestMatcher;
import org.pentaho.platform.web.gwt.rpc.matcher.SystemGwtRpcRequestMatcher;
import org.pentaho.platform.web.gwt.rpc.support.GwtRpcSerializationPolicyCache;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

class GwtRpcRequestMatcherParser
extends AbstractBeanDefinitionParser {
    private final boolean isPlugin;

    public GwtRpcRequestMatcherParser(boolean isPlugin) {
        this.isPlugin = isPlugin;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String pattern = element.getAttribute("pattern");
        String rpcMethods = element.getAttribute("methods");
        boolean isCaseInsensitive = Boolean.parseBoolean(element.getAttribute("insensitive"));
        if (pattern.equals("")) {
            parserContext.getReaderContext().fatal("'pattern' attribute is empty or unspecified.", (Object)element);
        }
        List<String> rpcMethodsList = null;
        if (!rpcMethods.equals("")) {
            rpcMethodsList = Arrays.asList(rpcMethods.split("\\s+"));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(this.getBeanClass());
        builder.addConstructorArgValue((Object)pattern);
        builder.addConstructorArgValue((Object)isCaseInsensitive);
        builder.addConstructorArgValue(rpcMethodsList);
        builder.addConstructorArgValue((Object)new GwtRpcSerializationPolicyCache());
        return builder.getBeanDefinition();
    }

    private Class<?> getBeanClass() {
        return this.isPlugin ? PluginGwtRpcRequestMatcher.class : SystemGwtRpcRequestMatcher.class;
    }
}

