/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc.matcher;

import com.hitachivantara.security.web.impl.model.matcher.RegexRequestMatcher;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.pentaho.platform.web.gwt.rpc.AbstractGwtRpc;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;

public abstract class AbstractGwtRpcRequestMatcher
extends RegexRequestMatcher {
    private static final Collection<String> HTTP_METHODS_GWT_RPC = Collections.singletonList("POST");
    @Nullable
    private final Collection<String> rpcMethodNames;
    @Nullable
    private final IGwtRpcSerializationPolicyCache serializationPolicyCache;

    public AbstractGwtRpcRequestMatcher(@NonNull String pattern, @Nullable Collection<String> rpcMethodNames, @Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        super(pattern, HTTP_METHODS_GWT_RPC);
        this.rpcMethodNames = rpcMethodNames;
        this.serializationPolicyCache = serializationPolicyCache;
    }

    public AbstractGwtRpcRequestMatcher(@NonNull String pattern, boolean isCaseInsensitive, @Nullable Collection<String> rpcMethodNames, @Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        super(pattern, HTTP_METHODS_GWT_RPC, isCaseInsensitive);
        this.rpcMethodNames = rpcMethodNames;
        this.serializationPolicyCache = serializationPolicyCache;
    }

    @Nullable
    public IGwtRpcSerializationPolicyCache getSerializationPolicyCache() {
        return this.serializationPolicyCache;
    }

    @Nullable
    public Collection<String> getRpcMethodNames() {
        return this.rpcMethodNames;
    }

    public boolean test(@NonNull HttpServletRequest httpRequest) {
        return super.test(httpRequest) && (this.rpcMethodNames == null || this.rpcMethodNames.contains(this.getRpcMethodName(httpRequest)));
    }

    @NonNull
    protected abstract AbstractGwtRpc getGwtRpc(@NonNull HttpServletRequest var1);

    @NonNull
    String getRpcMethodName(@NonNull HttpServletRequest httpRequest) {
        try {
            return this.getGwtRpc(httpRequest).getRequest().getMethod().getName();
        }
        catch (GwtRpcProxyException ex) {
            return "";
        }
    }
}

