/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.platform.web.gwt.rpc.util.ThrowingSupplier;

public class GwtRpcUtil {
    public static final String WEBAPP_ROOT_TOKEN = "WEBAPP_ROOT";
    private static final Pattern WEBAPP_ROOT_PATH_PATTERN = Pattern.compile("^/.*/WEBAPP_ROOT/");

    private GwtRpcUtil() {
    }

    public static String scrubWebAppRoot(String path, String appContextPath) {
        Matcher matcher;
        if (path.contains(WEBAPP_ROOT_TOKEN) && (matcher = WEBAPP_ROOT_PATH_PATTERN.matcher(path)).find()) {
            String garbagePathPart = matcher.group();
            int index = path.indexOf(garbagePathPart);
            return new StringBuffer(path).replace(index, index + garbagePathPart.length(), appContextPath).toString();
        }
        return path;
    }

    public static <T> T withClassLoader(@NonNull ClassLoader classLoader, @NonNull Supplier<T> supplier) {
        return (T)GwtRpcUtil.withClassLoaderThrowing(classLoader, supplier::get);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T withClassLoaderThrowing(@NonNull ClassLoader classLoader, @NonNull ThrowingSupplier<T, E> supplier) throws E {
        Objects.requireNonNull(classLoader);
        Objects.requireNonNull(supplier);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != originalClassLoader) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            T t = supplier.get();
            return t;
        }
        finally {
            if (classLoader != originalClassLoader && originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }
}

