/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.web.gwt.rpc.AbstractGwtRpc;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class SystemGwtRpc
extends AbstractGwtRpc {
    public SystemGwtRpc(@NonNull HttpServletRequest request) {
        super(request);
    }

    @Override
    @NonNull
    protected Object resolveTarget() throws GwtRpcProxyException {
        String beanId;
        ApplicationContext beanFactory = this.createAppContext();
        if (!beanFactory.containsBean(beanId = this.getTargetBeanId())) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcProxyServlet.ERROR_0001_NO_BEAN_FOUND_FOR_SERVICE", new Object[]{beanId, this.getServletContextPath()}));
        }
        try {
            return beanFactory.getBean(beanId);
        }
        catch (BeansException ex) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcProxyServlet.ERROR_0002_FAILED_TO_GET_BEAN_REFERENCE", new Object[]{beanId}), ex);
        }
    }

    @Override
    @Nullable
    protected SerializationPolicy loadSerializationPolicy(@NonNull String moduleContextPath, @Nullable String strongName) {
        String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(moduleContextPath + strongName));
        return SystemGwtRpc.loadSerializationPolicyFromInputStream(() -> this.getServletContext().getResourceAsStream(serializationPolicyFilePath), serializationPolicyFilePath);
    }

    @NonNull
    ApplicationContext createAppContext() {
        WebApplicationContext parent = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        XmlWebApplicationContext wac = new XmlWebApplicationContext(){

            protected Resource getResourceByPath(@NonNull String path) {
                return new FileSystemResource(new File(path));
            }
        };
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(this.getServletContext());
        wac.setNamespace("GwtRpcProxyServlet");
        String springFile = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentahoServices.spring.xml");
        wac.setConfigLocations(new String[]{springFile});
        wac.refresh();
        return wac;
    }

    @NonNull
    private String getTargetBeanId() {
        String servletContextPath = this.getServletContextPath();
        if (servletContextPath.startsWith("/")) {
            servletContextPath = servletContextPath.substring(1);
        }
        return servletContextPath.replaceAll("/", "-");
    }

    @NonNull
    public static SystemGwtRpc getInstance(@NonNull HttpServletRequest httpRequest) {
        return SystemGwtRpc.getInstance(httpRequest, null);
    }

    @NonNull
    public static SystemGwtRpc getInstance(@NonNull HttpServletRequest httpRequest, @Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        return SystemGwtRpc.getInstance(httpRequest, SystemGwtRpc::new, serializationPolicyCache);
    }
}

