/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc;

import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.pluginmgr.PluginUtil;
import org.pentaho.platform.web.gwt.rpc.AbstractGwtRpc;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.gwt.rpc.util.ThrowingSupplier;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.pentaho.platform.web.servlet.messages.Messages;

public class PluginGwtRpc
extends AbstractGwtRpc {
    private static final Log logger = LogFactory.getLog(PluginGwtRpc.class);

    public PluginGwtRpc(@NonNull HttpServletRequest request) {
        super(request);
    }

    @Override
    @NonNull
    protected Object resolveTarget() throws GwtRpcProxyException {
        String key;
        IServiceManager serviceManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        if (serviceManager.getServiceConfig("gwt", key = this.getServiceKey()) == null) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0001_SERVICE_NOT_FOUND", new Object[]{key}));
        }
        try {
            return serviceManager.getServiceBean("gwt", key);
        }
        catch (ServiceException e) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0002_FAILED_TO_GET_BEAN_REFERENCE", new Object[]{key}), e);
        }
    }

    @Override
    @Nullable
    protected SerializationPolicy loadSerializationPolicy(@NonNull String moduleContextPath, @Nullable String strongName) {
        String pluginId = PluginUtil.getPluginIdFromPath(moduleContextPath);
        SerializationPolicy serializationPolicy = (SerializationPolicy)PentahoSystem.get(SerializationPolicy.class, (IPentahoSession)PentahoSessionHolder.getSession(), Collections.singletonMap("plugin", pluginId));
        if (serializationPolicy != null) {
            return serializationPolicy;
        }
        String serializationPolicyFileName = SerializationPolicyLoader.getSerializationPolicyFileName((String)strongName);
        URL serializationPolicyUrl = this.getSerializationPolicyUrl(serializationPolicyFileName, moduleContextPath);
        return serializationPolicyUrl != null ? PluginGwtRpc.loadSerializationPolicyFromInputStream(this.getInputStreamSupplier(serializationPolicyUrl), serializationPolicyFileName) : null;
    }

    @NonNull
    ThrowingSupplier<InputStream, IOException> getInputStreamSupplier(@NonNull URL inputStreamURL) {
        return inputStreamURL::openStream;
    }

    @Nullable
    private URL getSerializationPolicyUrl(@NonNull String serializationPolicyFilename, String moduleContextPath) {
        ClassLoader serviceClassloader = PluginUtil.getClassLoaderForService(moduleContextPath);
        if (serviceClassloader == null) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0005_FAILED_TO_FIND_PLUGIN", new Object[]{this.getAppContextPath()}));
            return null;
        }
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, (IPentahoSession)PentahoSessionHolder.getSession());
        List urls = resLoader.findResources(serviceClassloader, serializationPolicyFilename);
        if (urls.size() < 1) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0006_FAILED_TO_FIND_FILE", new Object[]{serializationPolicyFilename}));
            return null;
        }
        if (urls.size() > 1) {
            logger.warn((Object)Messages.getInstance().getString("GwtRpcPluginProxyServlet.WARN_MULTIPLE_RESOURCES_FOUND", new Object[]{serializationPolicyFilename}));
        }
        return (URL)urls.get(0);
    }

    @NonNull
    private String getServiceKey() {
        String requestPathInfo = this.getServletRequest().getPathInfo();
        if (requestPathInfo.startsWith("/")) {
            requestPathInfo = requestPathInfo.substring(1);
        }
        if (requestPathInfo.contains("/")) {
            String[] elements = requestPathInfo.split("/");
            return elements[elements.length - 1];
        }
        return requestPathInfo;
    }

    @NonNull
    public static PluginGwtRpc getInstance(@NonNull HttpServletRequest httpRequest) {
        return PluginGwtRpc.getInstance(httpRequest, null);
    }

    @NonNull
    public static PluginGwtRpc getInstance(@NonNull HttpServletRequest httpRequest, @Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        return PluginGwtRpc.getInstance(httpRequest, PluginGwtRpc::new, serializationPolicyCache);
    }
}

