/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.gwt.rpc;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.gwt.rpc.IGwtRpcSerializationPolicyCache;
import org.pentaho.platform.web.gwt.rpc.impl.GwtRpcUtil;
import org.pentaho.platform.web.gwt.rpc.util.ThrowingSupplier;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.pentaho.platform.web.servlet.messages.Messages;

public abstract class AbstractGwtRpc {
    private static final Log logger = LogFactory.getLog(AbstractGwtRpc.class);
    protected static final String HTTP_GWT_RPC_ATTRIBUTE = AbstractGwtRpc.class.getSimpleName();
    @NonNull
    private final HttpServletRequest httpRequest;
    @Nullable
    private Object target;
    @Nullable
    private String requestPayload;
    @Nullable
    private RPCRequest request;
    @Nullable
    private IGwtRpcSerializationPolicyCache serializationPolicyCache;

    protected AbstractGwtRpc(@NonNull HttpServletRequest httpRequest) {
        Objects.requireNonNull(httpRequest);
        this.httpRequest = httpRequest;
    }

    public void setSerializationPolicyCache(@Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        this.serializationPolicyCache = serializationPolicyCache;
    }

    @Nullable
    public IGwtRpcSerializationPolicyCache getSerializationPolicyCache() {
        return this.serializationPolicyCache;
    }

    @NonNull
    public HttpServletRequest getServletRequest() {
        return this.httpRequest;
    }

    @NonNull
    protected ServletContext getServletContext() {
        return this.getServletRequest().getServletContext();
    }

    @NonNull
    protected String getAppContextPath() {
        return this.httpRequest.getContextPath();
    }

    @NonNull
    protected String getServletContextPath() {
        String path = this.httpRequest.getServletPath() + "/" + this.httpRequest.getPathInfo();
        if (path.contains("//")) {
            path = path.replaceAll("//", "/");
        }
        return path;
    }

    @NonNull
    public Object getTarget() {
        if (this.target == null) {
            try {
                this.target = this.resolveTarget();
            }
            catch (GwtRpcProxyException ex) {
                logger.error((Object)Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0001_FAILED_TO_RESOLVE_DISPATCH_TARGET", new Object[]{this.getServletContextPath()}), (Throwable)ex);
                throw ex;
            }
        }
        return this.target;
    }

    @NonNull
    public ClassLoader getTargetClassLoader() {
        return this.getTarget().getClass().getClassLoader();
    }

    @NonNull
    protected abstract Object resolveTarget();

    @NonNull
    public String getRequestPayload() throws GwtRpcProxyException {
        if (this.requestPayload == null) {
            try {
                this.requestPayload = RPCServletUtils.readContentAsGwtRpc((HttpServletRequest)this.httpRequest);
            }
            catch (IOException | ServletException ex) {
                String message = Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0002_RPC_INVALID_REQUEST");
                logger.error((Object)message, ex);
                throw new GwtRpcProxyException(message, ex);
            }
        }
        return this.requestPayload;
    }

    @NonNull
    public RPCRequest getRequest() {
        if (this.request == null) {
            String requestPayload = this.getRequestPayload();
            this.request = GwtRpcUtil.withClassLoader(this.getTargetClassLoader(), () -> this.getRequestCore(requestPayload));
        }
        return this.request;
    }

    @NonNull
    RPCRequest getRequestCore(@NonNull String requestPayload) {
        try {
            return RPC.decodeRequest((String)requestPayload, null, this::getSerializationPolicy);
        }
        catch (IncompatibleRemoteServiceException | IllegalArgumentException ex) {
            String message = Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0002_RPC_INVALID_REQUEST");
            logger.error((Object)message, ex);
            throw new GwtRpcProxyException(message, ex);
        }
    }

    @NonNull
    protected SerializationPolicy getSerializationPolicy(@Nullable String moduleBaseURL, @Nullable String strongName) {
        if (this.serializationPolicyCache != null) {
            return this.serializationPolicyCache.getSerializationPolicy(moduleBaseURL, strongName, this::getSerializationPolicyCore);
        }
        return this.getSerializationPolicyCore(moduleBaseURL, strongName);
    }

    @NonNull
    private SerializationPolicy getSerializationPolicyCore(@Nullable String moduleBaseURL, @Nullable String strongName) {
        String modulePath;
        if (moduleBaseURL == null) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0004_MALFORMED_URL", new Object[]{""}));
            return AbstractGwtRpc.getDefaultSerializationPolicy();
        }
        try {
            modulePath = new URL(moduleBaseURL).getPath();
        }
        catch (MalformedURLException ex) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0004_MALFORMED_URL", new Object[]{moduleBaseURL}), (Throwable)ex);
            return AbstractGwtRpc.getDefaultSerializationPolicy();
        }
        String appContextPath = this.getAppContextPath();
        modulePath = GwtRpcUtil.scrubWebAppRoot(modulePath, appContextPath);
        if (!modulePath.startsWith(appContextPath)) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0004_MALFORMED_URL", new Object[]{moduleBaseURL}));
            return AbstractGwtRpc.getDefaultSerializationPolicy();
        }
        String moduleContextPath = modulePath.substring(appContextPath.length());
        SerializationPolicy serializationPolicy = this.loadSerializationPolicy(moduleContextPath, strongName);
        return serializationPolicy != null ? serializationPolicy : AbstractGwtRpc.getDefaultSerializationPolicy();
    }

    @Nullable
    protected abstract SerializationPolicy loadSerializationPolicy(@NonNull String var1, @Nullable String var2);

    @NonNull
    protected static SerializationPolicy getDefaultSerializationPolicy() {
        return RPC.getDefaultSerializationPolicy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected static SerializationPolicy loadSerializationPolicyFromInputStream(@NonNull ThrowingSupplier<InputStream, IOException> inputStreamSupplier, @NonNull String serializationPolicyFileName) {
        try (InputStream rpcFileInputStream = inputStreamSupplier.get();){
            if (rpcFileInputStream != null) {
                SerializationPolicy serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)rpcFileInputStream, null);
                return serializationPolicy;
            }
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0007_FAILED_TO_OPEN_FILE", new Object[]{serializationPolicyFileName}));
            return null;
        }
        catch (IOException e) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0007_FAILED_TO_OPEN_FILE", new Object[]{serializationPolicyFileName}), (Throwable)e);
            return null;
        }
        catch (ParseException e) {
            logger.error((Object)Messages.getInstance().getErrorString("GwtRpcPluginProxyServlet.ERROR_0008_FAILED_TO_PARSE_FILE", new Object[]{serializationPolicyFileName}), (Throwable)e);
        }
        return null;
    }

    @NonNull
    public String invoke() {
        Object target = this.getTarget();
        Class<?> targetClass = target.getClass();
        RPCRequest rpcRequest = this.getRequest();
        try {
            Method targetMethod = this.getTargetMethod(targetClass, rpcRequest);
            return GwtRpcUtil.withClassLoaderThrowing(this.getTargetClassLoader(), () -> this.invokeCore(target, targetMethod, rpcRequest));
        }
        catch (SerializationException | NoSuchMethodException ex) {
            String message = Messages.getInstance().getErrorString("AbstractGwtRpcProxyServlet.ERROR_0003_RPC_INVOCATION_FAILED", new Object[]{targetClass.getName()});
            logger.error((Object)message, ex);
            throw new GwtRpcProxyException(message, ex);
        }
    }

    @NonNull
    Method getTargetMethod(@NonNull Class<?> targetClass, @NonNull RPCRequest rpcRequest) throws NoSuchMethodException {
        Method serviceInterfaceMethod = rpcRequest.getMethod();
        return targetClass.getMethod(serviceInterfaceMethod.getName(), serviceInterfaceMethod.getParameterTypes());
    }

    @NonNull
    String invokeCore(@NonNull Object target, @NonNull Method targetMethod, @NonNull RPCRequest rpcRequest) throws SerializationException {
        return RPC.invokeAndEncodeResponse((Object)target, (Method)targetMethod, (Object[])rpcRequest.getParameters(), (SerializationPolicy)rpcRequest.getSerializationPolicy());
    }

    @NonNull
    protected static <R extends AbstractGwtRpc> R getInstance(@NonNull HttpServletRequest httpRequest, @NonNull Function<HttpServletRequest, R> factory, @Nullable IGwtRpcSerializationPolicyCache serializationPolicyCache) {
        Objects.requireNonNull(httpRequest);
        Objects.requireNonNull(factory);
        AbstractGwtRpc rpc = (AbstractGwtRpc)httpRequest.getAttribute(HTTP_GWT_RPC_ATTRIBUTE);
        if (rpc == null) {
            rpc = (AbstractGwtRpc)factory.apply(httpRequest);
            if (rpc == null) {
                throw new RuntimeException("Factory returned a null GwtRpc instance");
            }
            rpc.setSerializationPolicyCache(serializationPolicyCache);
            httpRequest.setAttribute(HTTP_GWT_RPC_ATTRIBUTE, (Object)rpc);
        }
        return (R)rpc;
    }
}

