/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class PentahoCachingLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog(PentahoCachingLdapAuthoritiesPopulator.class);
    private static final String REGION_DEFAULT_NAME = "ldapPopulatorCache";
    private String cacheRegionName = "ldapPopulatorCache";
    private final LdapAuthoritiesPopulator delegate;
    private final ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
    private static final String ROLES_BY_USER = "GrantedAuthority by user ";

    public PentahoCachingLdapAuthoritiesPopulator(LdapAuthoritiesPopulator delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate LdapAuthoritiesPopulator cannot be null");
        }
        this.delegate = delegate;
        if (!this.cacheManager.cacheEnabled(this.cacheRegionName)) {
            this.cacheManager.addCacheRegion(this.cacheRegionName);
        }
    }

    private Collection<? extends GrantedAuthority> performOperation(String cacheEntry, DelegateOperation operation) {
        Collection<? extends GrantedAuthority> results = null;
        Object fromRegionCache = this.cacheManager.getFromRegionCache(this.cacheRegionName, (Object)cacheEntry);
        if (fromRegionCache instanceof Collection) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache Hit for  " + cacheEntry));
            }
            results = (Collection<? extends GrantedAuthority>)fromRegionCache;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss for  " + cacheEntry));
            }
            results = operation.perform();
            this.cacheManager.putInRegionCache(this.cacheRegionName, (Object)cacheEntry, results);
        }
        return new ArrayList<GrantedAuthority>(results);
    }

    public Collection<? extends GrantedAuthority> getGrantedAuthorities(DirContextOperations userData, String username) {
        return this.performOperation(ROLES_BY_USER + username, () -> this.delegate.getGrantedAuthorities(userData, username));
    }

    public String getCacheRegionName() {
        return this.cacheRegionName;
    }

    public void setCacheRegionName(String cacheRegionName) {
        this.cacheRegionName = cacheRegionName;
    }

    private static interface DelegateOperation {
        public Collection<? extends GrantedAuthority> perform();
    }
}

