/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.LdapAuthenticator;

public class PentahoCachingLdapAuthenticator
implements LdapAuthenticator {
    private static final Log logger = LogFactory.getLog(PentahoCachingLdapAuthenticator.class);
    private static final String REGION_DEFAULT_NAME = "ldapAuthenticatorCache";
    private static final String PASSWORD_HASH_METHOD = "SHA-256";
    private String cacheRegionName = "ldapAuthenticatorCache";
    private String passwordHashMethod = "SHA-256";
    private MessageDigest messageDigest;
    private final LdapAuthenticator delegate;
    private final ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
    private static final String ROLES_BY_USER = "AuthenticatorCache_";
    private static final int HASH_SALT = new Random().nextInt();

    public PentahoCachingLdapAuthenticator(LdapAuthenticator delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate LdapAuthenticator cannot be null");
        }
        this.delegate = delegate;
        if (!this.cacheManager.cacheEnabled(this.cacheRegionName)) {
            this.cacheManager.addCacheRegion(this.cacheRegionName);
        }
        try {
            this.messageDigest = MessageDigest.getInstance(PASSWORD_HASH_METHOD);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Issue trying to create a messageDigest for MD5");
        }
    }

    private DirContextOperations performOperation(Authentication authentication, DelegateOperation operation) {
        DirContextOperations results = null;
        Object fromRegionCache = null;
        String cacheEntry = ROLES_BY_USER + this.hashUserAndPassword(authentication);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("cacheEntry:" + cacheEntry));
        }
        if ((fromRegionCache = this.cacheManager.getFromRegionCache(this.cacheRegionName, (Object)cacheEntry)) instanceof DirContextOperations) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache Hit for " + authentication.getPrincipal()));
            }
            results = (DirContextOperations)fromRegionCache;
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cache miss for " + authentication.getPrincipal()));
            }
            results = operation.perform();
            this.cacheManager.putInRegionCache(this.cacheRegionName, (Object)cacheEntry, (Object)results);
        }
        return results;
    }

    public DirContextOperations authenticate(Authentication authentication) {
        return this.performOperation(authentication, () -> this.delegate.authenticate(authentication));
    }

    protected String hashUserAndPassword(Authentication authentication) {
        String stringToEncrypt = HASH_SALT + ":" + authentication.getPrincipal() + ":" + authentication.getCredentials();
        String encryptedString = new String(this.messageDigest.digest(stringToEncrypt.getBytes()));
        return new String(Base64.getEncoder().encode(encryptedString.getBytes()));
    }

    public String getCacheRegionName() {
        return this.cacheRegionName;
    }

    public void setCacheRegionName(String cacheRegionName) {
        this.cacheRegionName = cacheRegionName;
    }

    public String getPasswordHashMethod() {
        return this.passwordHashMethod;
    }

    public void setPasswordHashMethod(String passwordHashMethod) {
        this.passwordHashMethod = passwordHashMethod;
        try {
            this.messageDigest = MessageDigest.getInstance(passwordHashMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("hashMethod NoSuchAlgorithmException, default is SHA-256");
        }
    }

    private static interface DelegateOperation {
        public DirContextOperations perform();
    }
}

