/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;

public class SecuritySystemListener
implements IPentahoSystemListener {
    private static final Log logger = LogFactory.getLog(SecuritySystemListener.class);

    public boolean startup(IPentahoSession session) {
        PentahoSystem.get(ProviderManager.class, (String)"authenticationManager", (IPentahoSession)session);
        this.changeFilterChainProxyHttpFirewall();
        return true;
    }

    public void shutdown() {
    }

    private void changeFilterChainProxyHttpFirewall() {
        StrictHttpFirewall notSoStrictHttpFirewall = new StrictHttpFirewall();
        notSoStrictHttpFirewall.setAllowSemicolon(true);
        notSoStrictHttpFirewall.setAllowUrlEncodedPercent(true);
        notSoStrictHttpFirewall.setAllowUrlEncodedPeriod(true);
        try {
            FilterChainProxy filterChainProxy = (FilterChainProxy)PentahoSystem.get(FilterChainProxy.class, (String)"filterChainProxy", null);
            if (filterChainProxy != null) {
                logger.debug((Object)"Changing FilterChainProxy's HttpFirewall to a more lenient one that allows for the passing of semicolons, periods, and percentages signs in the URL path");
                filterChainProxy.setFirewall((HttpFirewall)notSoStrictHttpFirewall);
            }
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
    }
}

