/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.security.userroledao.messages.Messages;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ChainedUserDetailsService
implements UserDetailsService {
    private List<UserDetailsService> delegates = new ArrayList<UserDetailsService>();

    public ChainedUserDetailsService(List<UserDetailsService> delegates) {
        this.delegates.addAll(delegates);
    }

    public UserDetails loadUserByUsername(String s) throws UsernameNotFoundException, DataAccessException {
        for (UserDetailsService delegate : this.delegates) {
            try {
                UserDetails details = delegate.loadUserByUsername(s);
                if (details == null) continue;
                return details;
            }
            catch (UsernameNotFoundException usernameNotFoundException) {
            }
        }
        throw new UsernameNotFoundException(Messages.getInstance().getString("UserRoleDaoUserDetailsService.ERROR_0001_USER_NOT_FOUND"));
    }
}

