/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ExportFileNameEncoder {
    public static String encodeZipFileName(String fileName) {
        try {
            return URLEncoder.encode(fileName, "UTF-8").replace("*", "%2A");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return fileName;
        }
    }

    public static String decodeZipFileName(String encodedFileName) {
        try {
            return URLDecoder.decode(encodedFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return encodedFileName;
        }
    }

    public static String encodeZipPathName(String path) {
        String[] folders = path.split("/");
        StringBuilder encodedPath = new StringBuilder(path.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            encodedPath.append(ExportFileNameEncoder.encodeZipFileName(folders[i]));
            if (i == folders.length - 1 && !path.endsWith("/")) continue;
            encodedPath.append("/");
        }
        return encodedPath.toString();
    }

    public static String decodeZipPath(String encodedPath) {
        String[] folders = encodedPath.split("/");
        StringBuilder decodedPath = new StringBuilder(encodedPath.length() * 2);
        for (int i = 0; i < folders.length; ++i) {
            decodedPath.append(ExportFileNameEncoder.decodeZipFileName(folders[i]));
            if (i == folders.length - 1 && !encodedPath.endsWith("/")) continue;
            decodedPath.append("/");
        }
        return decodedPath.toString();
    }
}

