/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;
import org.pentaho.platform.plugin.services.messages.Messages;

public class CmdParser
extends Parser {
    private List<Object> tokens = new ArrayList<Object>();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        this.init();
        this.options = options;
        Iterator<String> iter = Arrays.asList(arguments).iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            if (token.startsWith("--")) {
                this.handleToken(options, stopAtNonOption, token);
            } else if ("-".equals(token)) {
                this.tokens.add(token);
            } else if (token.startsWith("-")) {
                if (token.length() == 2 || options.hasOption(token)) {
                    this.processOptionToken(token, stopAtNonOption);
                } else {
                    this.handleToken(options, stopAtNonOption, token);
                }
            } else {
                this.processNonOptionToken(token, stopAtNonOption);
            }
            this.gobble(iter);
        }
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    private void handleToken(Options options, boolean stopAtNonOption, String token) {
        String opt;
        int pos = token.indexOf(61);
        String string = opt = pos == -1 ? token : token.substring(0, pos);
        if (!options.hasOption(opt)) {
            this.processNonOptionToken(token, stopAtNonOption);
        } else {
            boolean isShortOptAndExists;
            Option option = options.getOption(opt);
            boolean isLongOptAndExists = opt.startsWith("--") && option.getLongOpt().equals(opt.substring(2, opt.length()));
            boolean bl = isShortOptAndExists = opt.startsWith("-") && option.getOpt().equals(opt.substring(1, opt.length()));
            if (isLongOptAndExists || isShortOptAndExists) {
                this.currentOption = option;
                this.tokens.add(opt);
                if (pos != -1) {
                    this.tokens.add(token.substring(pos + 1));
                }
            } else {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0008_INVALID_PARAMETER", new Object[]{opt}));
            }
        }
    }

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
    }

    private void processNonOptionToken(String value, boolean stopAtNonOption) {
        if (stopAtNonOption && (this.currentOption == null || !this.currentOption.hasArg())) {
            this.eatTheRest = true;
            this.tokens.add("--");
        }
        this.tokens.add(value);
    }

    private void processOptionToken(String token, boolean stopAtNonOption) {
        if (stopAtNonOption && !this.options.hasOption(token)) {
            this.eatTheRest = true;
        }
        if (this.options.hasOption(token)) {
            this.currentOption = this.options.getOption(token);
        }
        this.tokens.add(token);
    }

    private void gobble(Iterator iter) {
        if (this.eatTheRest) {
            while (iter.hasNext()) {
                this.tokens.add(iter.next());
            }
        }
    }
}

