/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.engine.security.userroledao.AlreadyExistsException;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.usersettings.IAnyUserSettingService;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFilesProcessor;
import org.pentaho.platform.plugin.services.importer.PentahoPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.SolutionFileImportHelper;
import org.pentaho.platform.plugin.services.importexport.DatabaseConnectionConverter;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ExportManifestUserSetting;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.RoleExport;
import org.pentaho.platform.plugin.services.importexport.UserExport;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifest;
import org.pentaho.platform.plugin.services.importexport.exportManifest.Parameters;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.DatabaseConnection;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetaStore;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetadata;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMondrian;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.web.http.api.resources.JobRequest;
import org.pentaho.platform.web.http.api.resources.JobScheduleParam;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.SchedulerResource;
import org.pentaho.platform.web.http.api.resources.services.FileService;

public class SolutionImportHandler
implements IPlatformImportHandler {
    private static final String RESERVEDMAPKEY_LINEAGE_ID = "lineage-id";
    private static final String XMI_EXTENSION = ".xmi";
    private static final String EXPORT_MANIFEST_XML_FILE = "exportManifest.xml";
    private static final String DOMAIN_ID = "domain-id";
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private IUnifiedRepository repository;
    protected Map<String, RepositoryFileImportBundle.Builder> cachedImports;
    private SolutionFileImportHelper solutionHelper;
    private List<IMimeType> mimeTypes;
    private boolean overwriteFile;
    private List<ImportSource.IRepositoryFileBundle> files;

    public SolutionImportHandler(List<IMimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
        this.solutionHelper = new SolutionFileImportHelper();
        this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    }

    public ImportSession getImportSession() {
        return ImportSession.getSession();
    }

    public Log getLogger() {
        return this.getImportSession().getLogger();
    }

    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
        if (!this.processZip(bundle.getInputStream())) {
            return;
        }
        LocaleFilesProcessor localeFilesProcessor = new LocaleFilesProcessor();
        this.setOverwriteFile(bundle.overwriteInRepository());
        IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        this.cachedImports = new HashMap<String, RepositoryFileImportBundle.Builder>();
        ExportManifest manifest = this.getImportSession().getManifest();
        String manifestVersion = null;
        if (manifest != null) {
            manifestVersion = manifest.getManifestInformation().getManifestVersion();
            Map<String, List<String>> roleToUserMap = this.importUsers(manifest.getUserExports());
            this.importRoles(manifest.getRoleExports(), roleToUserMap);
            this.importMetadata(manifest.getMetadataList(), bundle.isPreserveDsw());
            this.importMondrian(manifest.getMondrianList());
            this.importMetaStore(manifest.getMetaStore(), bundle.overwriteInRepository());
            List<DatabaseConnection> datasourceList = manifest.getDatasourceList();
            if (datasourceList != null) {
                IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class);
                for (DatabaseConnection databaseConnection : datasourceList) {
                    if (databaseConnection.getDatabaseType() == null) {
                        this.getLogger().warn((Object)Messages.getInstance().getString("SolutionImportHandler.ConnectionWithoutDatabaseType", new Object[]{databaseConnection.getName()}));
                        continue;
                    }
                    try {
                        IDatabaseConnection existingDBConnection = datasourceMgmtSvc.getDatasourceByName(databaseConnection.getName());
                        if (existingDBConnection != null && existingDBConnection.getName() != null) {
                            if (!this.isOverwriteFile()) continue;
                            databaseConnection.setId(existingDBConnection.getId());
                            datasourceMgmtSvc.updateDatasourceByName(databaseConnection.getName(), DatabaseConnectionConverter.export2model(databaseConnection));
                            continue;
                        }
                        datasourceMgmtSvc.createDatasource(DatabaseConnectionConverter.export2model(databaseConnection));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (ImportSource.IRepositoryFileBundle fileBundle : this.files) {
            String repositoryFilePath;
            String fileName = fileBundle.getFile().getName();
            String actualFilePath = fileBundle.getPath();
            if (manifestVersion != null) {
                fileName = ExportFileNameEncoder.decodeZipFileName(fileName);
                actualFilePath = ExportFileNameEncoder.decodeZipFileName(actualFilePath);
            }
            if (this.cachedImports.containsKey(repositoryFilePath = RepositoryFilenameUtils.concat((String)PentahoPlatformImporter.computeBundlePath(actualFilePath), (String)fileName))) {
                byte[] bytes = IOUtils.toByteArray((InputStream)fileBundle.getInputStream());
                RepositoryFileImportBundle.Builder builder = this.cachedImports.get(repositoryFilePath);
                builder.input(new ByteArrayInputStream(bytes));
                importer.importFile(this.build(builder));
                continue;
            }
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
            ByteArrayInputStream bundleInputStream = null;
            String decodedFilePath = fileBundle.getPath();
            RepositoryFile decodedFile = fileBundle.getFile();
            if (manifestVersion != null) {
                decodedFile = new RepositoryFile.Builder(decodedFile).path(decodedFilePath).name(fileName).title(fileName).build();
                decodedFilePath = ExportFileNameEncoder.decodeZipFileName(fileBundle.getPath());
            }
            if (fileBundle.getFile().isFolder()) {
                bundleBuilder.mime("text/directory");
                bundleBuilder.file(decodedFile);
                fileName = repositoryFilePath;
                repositoryFilePath = importBundle.getPath();
            } else {
                byte[] bytes = IOUtils.toByteArray((InputStream)fileBundle.getInputStream());
                bundleInputStream = new ByteArrayInputStream(bytes);
                if (localeFilesProcessor.isLocaleFile(fileBundle, importBundle.getPath(), bytes)) {
                    this.getLogger().trace((Object)Messages.getInstance().getString("SolutionImportHandler.SkipLocaleFile", new Object[]{repositoryFilePath}));
                    continue;
                }
                bundleBuilder.input(bundleInputStream);
                bundleBuilder.mime(this.solutionHelper.getMime(fileName));
                String filePath = decodedFilePath.equals("/") || decodedFilePath.equals("\\") ? "" : decodedFilePath;
                repositoryFilePath = RepositoryFilenameUtils.concat((String)importBundle.getPath(), (String)filePath);
            }
            bundleBuilder.name(fileName);
            bundleBuilder.path(repositoryFilePath);
            String sourcePath = fileBundle.getFile().isFolder() ? fileName : RepositoryFilenameUtils.concat((String)PentahoPlatformImporter.computeBundlePath(actualFilePath), (String)fileName);
            if (manifest != null && manifest.getExportManifestEntity(sourcePath) == null && fileBundle.getFile().isFolder()) continue;
            this.getImportSession().setCurrentManifestKey(sourcePath);
            bundleBuilder.charSet(bundle.getCharSet());
            bundleBuilder.overwriteFile(bundle.overwriteInRepository());
            bundleBuilder.applyAclSettings(bundle.isApplyAclSettings());
            bundleBuilder.retainOwnership(bundle.isRetainOwnership());
            bundleBuilder.overwriteAclSettings(bundle.isOverwriteAclSettings());
            bundleBuilder.acl(this.getImportSession().processAclForFile(sourcePath));
            bundleBuilder.extraMetaData(this.getImportSession().processExtraMetaDataForFile(sourcePath));
            RepositoryFile file = this.getFile(importBundle, fileBundle);
            ImportSession.ManifestFile manifestFile = this.getImportSession().getManifestFile(sourcePath, file != null);
            bundleBuilder.hidden(this.isFileHidden(file, manifestFile, sourcePath));
            boolean isSchedulable = this.isSchedulable(file, manifestFile);
            if (isSchedulable) {
                bundleBuilder.schedulable(isSchedulable);
            } else {
                bundleBuilder.schedulable(this.fileIsScheduleInputSource(manifest, sourcePath));
            }
            IPlatformImportBundle platformImportBundle = this.build(bundleBuilder);
            importer.importFile(platformImportBundle);
            if (bundleInputStream == null) continue;
            ((InputStream)bundleInputStream).close();
            bundleInputStream = null;
        }
        if (manifest != null) {
            this.importSchedules(manifest.getScheduleList());
        }
        localeFilesProcessor.processLocaleFiles(importer);
    }

    List<Job> getAllJobs(SchedulerResource schedulerResource) {
        return schedulerResource.getAllJobs();
    }

    private RepositoryFile getFile(IPlatformImportBundle importBundle, ImportSource.IRepositoryFileBundle fileBundle) {
        String repositoryFilePath = this.repositoryPathConcat(importBundle.getPath(), fileBundle.getPath(), fileBundle.getFile().getName());
        return this.repository.getFile(repositoryFilePath);
    }

    protected void importSchedules(List<JobScheduleRequest> scheduleList) throws PlatformImportException {
        if (CollectionUtils.isNotEmpty(scheduleList)) {
            SchedulerResource schedulerResource = new SchedulerResource();
            schedulerResource.pause();
            for (JobScheduleRequest jobScheduleRequest : scheduleList) {
                boolean jobExists = false;
                List<Job> jobs = this.getAllJobs(schedulerResource);
                if (jobs != null) {
                    HashMap<String, Serializable> mapParamsRequest = new HashMap<String, Serializable>();
                    for (JobScheduleParam paramRequest : jobScheduleRequest.getJobParameters()) {
                        mapParamsRequest.put(paramRequest.getName(), paramRequest.getValue());
                    }
                    for (Job job : jobs) {
                        if (mapParamsRequest.get(RESERVEDMAPKEY_LINEAGE_ID) != null && ((Serializable)mapParamsRequest.get(RESERVEDMAPKEY_LINEAGE_ID)).equals(job.getJobParams().get(RESERVEDMAPKEY_LINEAGE_ID))) {
                            jobExists = true;
                        }
                        if (!this.overwriteFile || !jobExists) continue;
                        JobRequest jobRequest = new JobRequest();
                        jobRequest.setJobId(job.getJobId());
                        schedulerResource.removeJob(jobRequest);
                        jobExists = false;
                        break;
                    }
                }
                if (!jobExists) {
                    try {
                        Response response = this.createSchedulerJob(schedulerResource, jobScheduleRequest);
                        if (response.getStatus() != Response.Status.OK.getStatusCode() || response.getEntity() == null) continue;
                        ImportSession.getSession().addImportedScheduleJobId(response.getEntity().toString());
                    }
                    catch (Exception e) {
                        if (jobScheduleRequest.getInputFile().contains(" ") || jobScheduleRequest.getOutputFile().contains(" ")) {
                            this.getLogger().info((Object)Messages.getInstance().getString("SolutionImportHandler.SchedulesWithSpaces", new Object[]{jobScheduleRequest.getInputFile()}));
                            File inFile = new File(jobScheduleRequest.getInputFile());
                            File outFile = new File(jobScheduleRequest.getOutputFile());
                            String inputFileName = inFile.getParent() + "/" + inFile.getName().replace(" ", "_");
                            String outputFileName = outFile.getParent() + "/" + outFile.getName().replace(" ", "_");
                            jobScheduleRequest.setInputFile(inputFileName);
                            jobScheduleRequest.setOutputFile(outputFileName);
                            try {
                                Response response;
                                if (!File.separator.equals("/")) {
                                    jobScheduleRequest.setInputFile(inputFileName.replace(File.separator, "/"));
                                    jobScheduleRequest.setOutputFile(outputFileName.replace(File.separator, "/"));
                                }
                                if ((response = this.createSchedulerJob(schedulerResource, jobScheduleRequest)).getStatus() != Response.Status.OK.getStatusCode() || response.getEntity() == null) continue;
                                ImportSession.getSession().addImportedScheduleJobId(response.getEntity().toString());
                            }
                            catch (Exception ex) {
                                this.getLogger().error((Object)Messages.getInstance().getString("SolutionImportHandler.ERROR_0001_ERROR_CREATING_SCHEDULE", new Object[]{e.getMessage()}), (Throwable)ex);
                            }
                            continue;
                        }
                        this.getLogger().error((Object)Messages.getInstance().getString("SolutionImportHandler.ERROR_0001_ERROR_CREATING_SCHEDULE", new Object[]{e.getMessage()}));
                    }
                    continue;
                }
                this.getLogger().info((Object)Messages.getInstance().getString("DefaultImportHandler.ERROR_0009_OVERWRITE_CONTENT", new Object[]{jobScheduleRequest.toString()}));
            }
            schedulerResource.start();
        }
    }

    protected void importMetaStore(ExportManifestMetaStore manifestMetaStore, boolean overwrite) {
        if (manifestMetaStore != null) {
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().path(manifestMetaStore.getFile()).name(manifestMetaStore.getName()).withParam("description", manifestMetaStore.getDescription()).charSet(UTF_8).overwriteFile(overwrite).mime("application/vnd.pentaho.metastore");
            this.cachedImports.put(manifestMetaStore.getFile(), bundleBuilder);
        }
    }

    protected Map<String, List<String>> importUsers(List<UserExport> users) {
        HashMap<String, List<String>> roleToUserMap = new HashMap<String, List<String>>();
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
        Tenant tenant = new Tenant("/pentaho/" + TenantUtils.getDefaultTenant(), Boolean.valueOf(true));
        if (users != null && roleDao != null) {
            for (UserExport user : users) {
                String password = user.getPassword();
                this.getLogger().debug((Object)Messages.getInstance().getString("USER.importing", new Object[]{user.getUsername()}));
                for (String role : user.getRoles()) {
                    List<String> userList;
                    if (!roleToUserMap.containsKey(role)) {
                        userList = new ArrayList();
                        roleToUserMap.put(role, userList);
                    } else {
                        userList = (List)roleToUserMap.get(role);
                    }
                    userList.add(user.getUsername());
                }
                String[] userRoles = user.getRoles().toArray(new String[0]);
                try {
                    roleDao.createUser((ITenant)tenant, user.getUsername(), password, null, userRoles);
                }
                catch (AlreadyExistsException e) {
                    this.getLogger().info((Object)Messages.getInstance().getString("USER.Already.Exists", new Object[]{user.getUsername()}));
                    try {
                        if (this.isOverwriteFile()) {
                            roleDao.setUserRoles((ITenant)tenant, user.getUsername(), userRoles);
                            roleDao.setPassword((ITenant)tenant, user.getUsername(), password);
                        }
                    }
                    catch (Exception ex) {
                        this.getLogger().debug((Object)Messages.getInstance().getString("ERROR.OverridingExistingUser", new Object[]{user.getUsername()}), (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    this.getLogger().error((Object)Messages.getInstance().getString("ERROR.OverridingExistingUser", new Object[]{user.getUsername()}), (Throwable)e);
                }
                this.importUserSettings(user);
            }
        }
        return roleToUserMap;
    }

    protected void importGlobalUserSettings(List<ExportManifestUserSetting> globalSettings) {
        IUserSettingService settingService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class);
        if (settingService != null) {
            for (ExportManifestUserSetting globalSetting : globalSettings) {
                if (this.isOverwriteFile()) {
                    settingService.setGlobalUserSetting(globalSetting.getName(), globalSetting.getValue());
                    continue;
                }
                IUserSetting userSetting = settingService.getGlobalUserSetting(globalSetting.getName(), null);
                if (userSetting != null) continue;
                settingService.setGlobalUserSetting(globalSetting.getName(), globalSetting.getValue());
            }
        }
    }

    protected void importUserSettings(UserExport user) {
        IUserSettingService settingService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class);
        IAnyUserSettingService userSettingService = null;
        if (settingService != null && settingService instanceof IAnyUserSettingService) {
            userSettingService = (IAnyUserSettingService)settingService;
        }
        if (userSettingService != null) {
            List<ExportManifestUserSetting> exportedSettings = user.getUserSettings();
            try {
                for (ExportManifestUserSetting exportedSetting : exportedSettings) {
                    if (this.isOverwriteFile()) {
                        userSettingService.setUserSetting(user.getUsername(), exportedSetting.getName(), exportedSetting.getValue());
                        continue;
                    }
                    IUserSetting userSetting = userSettingService.getUserSetting(user.getUsername(), exportedSetting.getName(), null);
                    if (userSetting != null) continue;
                    userSettingService.setUserSetting(user.getUsername(), exportedSetting.getName(), exportedSetting.getValue());
                }
            }
            catch (SecurityException e) {
                String errorMsg = Messages.getInstance().getString("ERROR.ImportingUserSetting", new Object[]{user.getUsername()});
                this.getLogger().error((Object)errorMsg);
                this.getLogger().debug((Object)errorMsg, (Throwable)e);
            }
        }
    }

    protected void importRoles(List<RoleExport> roles, Map<String, List<String>> roleToUserMap) {
        if (roles != null) {
            IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
            Tenant tenant = new Tenant("/pentaho/" + TenantUtils.getDefaultTenant(), Boolean.valueOf(true));
            IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
            HashSet<String> existingRoles = new HashSet<String>();
            for (RoleExport role : roles) {
                this.getLogger().debug((Object)Messages.getInstance().getString("ROLE.importing", new Object[]{role.getRolename()}));
                try {
                    List<String> users = roleToUserMap.get(role.getRolename());
                    String[] userarray = users == null ? new String[]{} : users.toArray(new String[0]);
                    IPentahoRole iPentahoRole = roleDao.createRole((ITenant)tenant, role.getRolename(), null, userarray);
                }
                catch (AlreadyExistsException e) {
                    existingRoles.add(role.getRolename());
                    this.getLogger().info((Object)Messages.getInstance().getString("ROLE.Already.Exists", new Object[]{role.getRolename()}));
                }
                try {
                    if (existingRoles.contains(role.getRolename())) {
                        if (!this.isOverwriteFile()) continue;
                        roleBindingDao.setRoleBindings((ITenant)tenant, role.getRolename(), role.getPermissions());
                        continue;
                    }
                    roleBindingDao.setRoleBindings((ITenant)tenant, role.getRolename(), role.getPermissions());
                }
                catch (Exception e) {
                    this.getLogger().info((Object)Messages.getInstance().getString("ERROR.SettingRolePermissions", new Object[]{role.getRolename()}), (Throwable)e);
                }
            }
        }
    }

    protected void importMetadata(List<ExportManifestMetadata> metadataList, boolean preserveDsw) {
        if (null != metadataList) {
            for (ExportManifestMetadata exportManifestMetadata : metadataList) {
                String domainId = exportManifestMetadata.getDomainId();
                if (domainId != null && !domainId.endsWith(XMI_EXTENSION)) {
                    domainId = domainId + XMI_EXTENSION;
                }
                RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().charSet(UTF_8).hidden(false).schedulable(true).preserveDsw(preserveDsw).overwriteFile(this.isOverwriteFile()).mime("text/xmi+xml").withParam(DOMAIN_ID, domainId);
                this.cachedImports.put(exportManifestMetadata.getFile(), bundleBuilder);
            }
        }
    }

    protected void importMondrian(List<ExportManifestMondrian> mondrianList) {
        if (null != mondrianList) {
            for (ExportManifestMondrian exportManifestMondrian : mondrianList) {
                String catName = exportManifestMondrian.getCatalogName();
                Parameters parametersMap = exportManifestMondrian.getParameters();
                StringBuilder parametersStr = new StringBuilder();
                for (Map.Entry e : parametersMap.entrySet()) {
                    parametersStr.append((String)e.getKey()).append('=').append((String)e.getValue()).append(';');
                }
                RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().charSet(UTF_8).hidden(false).schedulable(true).name(catName).overwriteFile(this.isOverwriteFile()).mime("application/vnd.pentaho.mondrian+xml").withParam("parameters", parametersStr.toString()).withParam(DOMAIN_ID, catName);
                String xmlaEnabled = "" + exportManifestMondrian.isXmlaEnabled();
                bundleBuilder.withParam("EnableXmla", xmlaEnabled);
                this.cachedImports.put(exportManifestMondrian.getFile(), bundleBuilder);
                String annotationsFile = exportManifestMondrian.getAnnotationsFile();
                if (annotationsFile == null) continue;
                RepositoryFileImportBundle.Builder annotationsBundle = new RepositoryFileImportBundle.Builder().path(MondrianCatalogRepositoryHelper.ETC_MONDRIAN_JCR_FOLDER + "/" + catName).name("annotations.xml").charSet(UTF_8).overwriteFile(this.isOverwriteFile()).mime("text/xml").hidden(false).schedulable(true).withParam(DOMAIN_ID, catName);
                this.cachedImports.put(annotationsFile, annotationsBundle);
            }
        }
    }

    @VisibleForTesting
    boolean fileIsScheduleInputSource(ExportManifest manifest, String sourcePath) {
        boolean isSchedulable = false;
        if (sourcePath != null && manifest != null && manifest.getScheduleList() != null) {
            String path = sourcePath.startsWith("/") ? sourcePath : "/" + sourcePath;
            isSchedulable = manifest.getScheduleList().stream().anyMatch(schedule -> path.equals(schedule.getInputFile()));
        }
        if (isSchedulable) {
            this.getLogger().warn((Object)Messages.getInstance().getString("ERROR.ScheduledWithoutPermission", new Object[]{sourcePath}));
            this.getLogger().warn((Object)Messages.getInstance().getString("SCHEDULE.AssigningPermission", new Object[]{sourcePath}));
        }
        return isSchedulable;
    }

    @VisibleForTesting
    protected boolean isFileHidden(RepositoryFile file, ImportSession.ManifestFile manifestFile, String sourcePath) {
        Boolean result = manifestFile.isFileHidden();
        if (result != null) {
            return result;
        }
        if (file != null) {
            return file.isHidden();
        }
        return this.solutionHelper.isInHiddenList(sourcePath);
    }

    @VisibleForTesting
    protected boolean isSchedulable(RepositoryFile file, ImportSession.ManifestFile manifestFile) {
        Boolean result = manifestFile.isFileSchedulable();
        if (result != null) {
            return result;
        }
        if (file != null) {
            return file.isSchedulable();
        }
        return true;
    }

    private String repositoryPathConcat(String path, String ... subPaths) {
        for (String subPath : subPaths) {
            path = RepositoryFilenameUtils.concat((String)path, (String)subPath);
        }
        return path;
    }

    private boolean processZip(InputStream inputStream) {
        this.files = new ArrayList<ImportSource.IRepositoryFileBundle>();
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            FileService fileService = new FileService();
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String entryName = RepositoryFilenameUtils.separatorsToRepository((String)entry.getName());
                this.getLogger().trace((Object)Messages.getInstance().getString("ZIPFILE.ProcessingEntry", new Object[]{entryName}));
                String decodedEntryName = ExportFileNameEncoder.decodeZipFileName(entryName);
                File tempFile = null;
                boolean isDir = entry.isDirectory();
                if (!isDir) {
                    if (!this.solutionHelper.isInApprovedExtensionList(entryName)) {
                        zipInputStream.closeEntry();
                        entry = zipInputStream.getNextEntry();
                        continue;
                    }
                    if (!fileService.isValidFileName(decodedEntryName)) {
                        throw new PlatformImportException(Messages.getInstance().getString("DefaultImportHandler.ERROR_0011_INVALID_FILE_NAME", new Object[]{entryName}), 10);
                    }
                    tempFile = File.createTempFile("zip", null);
                    tempFile.deleteOnExit();
                    try (FileOutputStream fos = new FileOutputStream(tempFile);){
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)fos);
                    }
                } else if (!fileService.isValidFileName(decodedEntryName)) {
                    throw new PlatformImportException(Messages.getInstance().getString("DefaultImportHandler.ERROR_0012_INVALID_FOLDER_NAME", new Object[]{entryName}), 10);
                }
                File file = new File(entryName);
                RepositoryFile repoFile = new RepositoryFile.Builder(file.getName()).folder(isDir).hidden(false).build();
                String parentDir = file.getParent() == null ? "/" : file.getParent() + "/";
                RepositoryFileBundle repoFileBundle = new RepositoryFileBundle(repoFile, null, parentDir, tempFile, UTF_8, null);
                if (EXPORT_MANIFEST_XML_FILE.equals(file.getName())) {
                    this.initializeAclManifest(repoFileBundle);
                } else {
                    this.files.add(repoFileBundle);
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (IOException | PlatformImportException e) {
            this.getLogger().error((Object)Messages.getInstance().getErrorString("ZIPFILE.ExceptionOccurred", new Object[]{e.getLocalizedMessage()}), (Throwable)e);
            return false;
        }
        return true;
    }

    private void initializeAclManifest(ImportSource.IRepositoryFileBundle file) {
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)file.getInputStream());
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            this.getImportSession().setManifest(ExportManifest.fromXml(in));
        }
        catch (Exception e) {
            this.getLogger().trace((Object)e);
        }
    }

    @Override
    public List<IMimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    public IPlatformImportBundle build(RepositoryFileImportBundle.Builder builder) {
        return builder != null ? builder.build() : null;
    }

    public Response createSchedulerJob(SchedulerResource scheduler, JobScheduleRequest jobScheduleRequest) throws IOException {
        Response rs;
        Response response = rs = scheduler != null ? scheduler.createJob(jobScheduleRequest) : null;
        if (jobScheduleRequest.getJobState() != Job.JobState.NORMAL) {
            JobRequest jobRequest = new JobRequest();
            jobRequest.setJobId(rs.getEntity().toString());
            scheduler.pauseJob(jobRequest);
        }
        return rs;
    }

    public boolean isOverwriteFile() {
        return this.overwriteFile;
    }

    public void setOverwriteFile(boolean overwriteFile) {
        this.overwriteFile = overwriteFile;
    }
}

