/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.ConverterException;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryAccessDeniedException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.IRepositoryImportLogger;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class PentahoPlatformImporter
implements IPlatformImporter {
    private static final Log log = LogFactory.getLog(PentahoPlatformImporter.class);
    private static final Messages messages = Messages.getInstance();
    private Map<String, IPlatformImportHandler> importHandlers;
    private IPlatformImportHandler defaultHandler;
    private IPlatformMimeResolver mimeResolver;
    private IRepositoryImportLogger repositoryImportLogger;
    private IRepositoryContentConverterHandler repositoryContentConverterHandler;

    public PentahoPlatformImporter(List<IPlatformImportHandler> handlerList, IRepositoryContentConverterHandler repositoryContentConverterHandler) {
        this.repositoryContentConverterHandler = repositoryContentConverterHandler;
        this.importHandlers = new HashMap<String, IPlatformImportHandler>();
        this.mimeResolver = (IPlatformMimeResolver)PentahoSystem.get(IPlatformMimeResolver.class);
        for (IPlatformImportHandler platformImportHandler : handlerList) {
            this.addHandler(platformImportHandler);
        }
    }

    public IPlatformImportHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(IPlatformImportHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public void addHandler(String mimeType, IPlatformImportHandler handler) {
        this.importHandlers.put(mimeType, handler);
    }

    @Override
    public void addHandler(IPlatformImportHandler platformImportHandler) {
        for (IMimeType mimeType : platformImportHandler.getMimeTypes()) {
            this.importHandlers.put(mimeType.getName(), platformImportHandler);
            this.mimeResolver.addMimeType(mimeType);
            for (String extension : mimeType.getExtensions()) {
                this.repositoryContentConverterHandler.addConverter(extension, mimeType.getConverter());
            }
        }
    }

    @Override
    public void importFile(IPlatformImportBundle file) throws PlatformImportException {
        block15: {
            String mime = file.getMimeType() != null ? file.getMimeType() : this.mimeResolver.resolveMimeForBundle(file);
            try {
                IPlatformImportHandler handler;
                if (mime == null) {
                    log.trace((Object)(messages.getString("PentahoPlatformImporter.ERROR_0001_INVALID_MIME_TYPE") + file.getName()));
                    this.repositoryImportLogger.error(messages.getString("PentahoPlatformImporter.ERROR_0001_INVALID_MIME_TYPE") + file.getName());
                    return;
                }
                IPlatformImportHandler iPlatformImportHandler = handler = !this.importHandlers.containsKey(mime) ? this.defaultHandler : this.importHandlers.get(mime);
                if (handler == null) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0002_MISSING_IMPORT_HANDLER"), 2);
                }
                try {
                    this.logImportFile(file);
                    handler.importFile(file);
                }
                catch (DomainIdNullException e1) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0004_PUBLISH_TO_SERVER_FAILED"), 1, e1);
                }
                catch (DomainAlreadyExistsException e1) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0007_PUBLISH_SCHEMA_EXISTS_ERROR"), 8, e1);
                }
                catch (DomainStorageException e1) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0004_PUBLISH_TO_SERVER_FAILED"), 6, e1);
                }
                catch (IOException e1) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0005_PUBLISH_GENERAL_ERRORR", new Object[]{e1.getLocalizedMessage()}), 2, e1);
                }
                catch (PlatformImportException pe) {
                    throw pe;
                }
                catch (ConverterException ce) {
                    Throwable cause = ce.getCause();
                    if (cause instanceof KettleMissingPluginsException) {
                        throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0008_PUBLISH_JOB_OR_TRANS_WITH_MISSING_PLUGINS", new Object[]{cause.getLocalizedMessage()}), 11, cause);
                    }
                }
                catch (Exception e1) {
                    throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0005_PUBLISH_GENERAL_ERRORR", new Object[]{e1.getLocalizedMessage()}), 2, e1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                RepositoryFileImportBundle bundle = (RepositoryFileImportBundle)file;
                String repositoryFilePath = RepositoryFilenameUtils.concat((String)bundle.getPath(), (String)bundle.getName());
                if (!this.repositoryImportLogger.hasLogger() || repositoryFilePath == null || repositoryFilePath.length() <= 0) {
                    if (e instanceof PlatformImportException) {
                        throw (PlatformImportException)e;
                    }
                    throw new PlatformImportException(e.getMessage());
                }
                this.repositoryImportLogger.error(e);
                if (!(e.getCause() instanceof UnifiedRepositoryAccessDeniedException)) break block15;
                throw new UnifiedRepositoryAccessDeniedException();
            }
        }
    }

    private void logImportFile(IPlatformImportBundle file) {
        RepositoryFileImportBundle bundle = (RepositoryFileImportBundle)file;
        String repositoryFilePath = RepositoryFilenameUtils.concat((String)bundle.getPath(), (String)bundle.getName());
        if (this.repositoryImportLogger.hasLogger() && repositoryFilePath != null && repositoryFilePath.length() > 0) {
            this.repositoryImportLogger.setCurrentFilePath(repositoryFilePath);
            this.repositoryImportLogger.warn(file.getName());
        }
    }

    public static String computeBundlePath(String bundlePath) {
        if ((bundlePath = RepositoryFilenameUtils.separatorsToRepository((String)bundlePath)).startsWith("/")) {
            bundlePath = bundlePath.substring(1);
        }
        return bundlePath;
    }

    public static String checkAndSanitize(String in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        String extension = null;
        if (in.endsWith(RepositoryObjectType.CLUSTER_SCHEMA.getExtension())) {
            extension = RepositoryObjectType.CLUSTER_SCHEMA.getExtension();
        } else if (in.endsWith(RepositoryObjectType.DATABASE.getExtension())) {
            extension = RepositoryObjectType.DATABASE.getExtension();
        } else if (in.endsWith(RepositoryObjectType.JOB.getExtension())) {
            extension = RepositoryObjectType.JOB.getExtension();
        } else if (in.endsWith(RepositoryObjectType.PARTITION_SCHEMA.getExtension())) {
            extension = RepositoryObjectType.PARTITION_SCHEMA.getExtension();
        } else if (in.endsWith(RepositoryObjectType.SLAVE_SERVER.getExtension())) {
            extension = RepositoryObjectType.SLAVE_SERVER.getExtension();
        } else if (in.endsWith(RepositoryObjectType.TRANSFORMATION.getExtension())) {
            extension = RepositoryObjectType.TRANSFORMATION.getExtension();
        }
        String out = in;
        if (extension != null) {
            out = out.substring(0, out.length() - extension.length());
        }
        if (out.contains("/") || out.equals("..") || out.equals(".") || StringUtils.isBlank((String)out)) {
            throw new IllegalArgumentException();
        }
        if (System.getProperty("KETTLE_COMPATIBILITY_PUR_OLD_NAMING_MODE", "N").equals("Y")) {
            out = out.replaceAll("[/:\\[\\]\\*'\"\\|\\s\\.]", "_");
        }
        if (extension != null) {
            return out + extension;
        }
        return out;
    }

    @Override
    public IRepositoryImportLogger getRepositoryImportLogger() {
        return this.repositoryImportLogger;
    }

    public void setRepositoryImportLogger(IRepositoryImportLogger repositoryImportLogger) {
        this.repositoryImportLogger = repositoryImportLogger;
    }

    @Override
    public Map<String, IPlatformImportHandler> getHandlers() {
        return this.importHandlers;
    }
}

