/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.hql;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.Type;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.platform.plugin.services.connections.hql.HQLMetaData;
import org.pentaho.platform.plugin.services.messages.Messages;

public class HQLResultSet
implements IPentahoResultSet,
IPeekable {
    private static final int COUNT_NEVER_OBTAINED = -2;
    private int rowCount = -2;
    private int columnCount = -2;
    private static final Log log = LogFactory.getLog(HQLResultSet.class);
    private IPentahoMetaData metadata;
    private List nativeResultSet = null;
    protected Object[] peekRow;
    private int index = 0;

    public HQLResultSet(List list, String[] columnNames, Type[] columnTypes) {
        try {
            this.nativeResultSet = list;
            this.metadata = new HQLMetaData(list, this, columnNames, columnTypes);
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getErrorString("SQLResultSet.ERROR_0004_GET_METADATA"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setMetaData(IPentahoMetaData metadata) {
        this.metadata = metadata;
    }

    public IPentahoMetaData getMetaData() {
        return this.metadata;
    }

    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        try {
            if (this.index < this.nativeResultSet.size()) {
                Object row;
                if ((row = this.nativeResultSet.get(this.index++)) instanceof Object[]) {
                    return (Object[])row;
                }
                Object[] newRow = new Object[]{row};
                return newRow;
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getErrorString("SQLResultSet.ERROR_0005_NEXT"), (Throwable)e);
        }
        return null;
    }

    public void closeConnection() {
        this.close();
    }

    public void close() {
    }

    public void dispose() {
        this.closeConnection();
    }

    public boolean isScrollable() {
        return false;
    }

    public int getColumnCount() {
        if (this.columnCount != -2) {
            return this.columnCount;
        }
        if (this.nativeResultSet.size() > 0) {
            Object row = this.nativeResultSet.get(0);
            this.columnCount = row instanceof Object[] ? ((Object[])row).length : 1;
            return this.columnCount;
        }
        return 0;
    }

    public int getRowCount() {
        if (this.rowCount != -2) {
            return this.rowCount;
        }
        this.rowCount = this.nativeResultSet.size();
        return this.rowCount;
    }

    public Object getValueAt(int row, int column) {
        if (row < this.nativeResultSet.size()) {
            Object rowObj = this.nativeResultSet.get(row);
            if (rowObj instanceof Object[]) {
                return ((Object[])rowObj)[column];
            }
            return rowObj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet memoryCopy() {
        try {
            IPentahoMetaData localMetadata = this.getMetaData();
            Object[][] columnHeaders = localMetadata.getColumnHeaders();
            MemoryMetaData cachedMetaData = new MemoryMetaData(columnHeaders, null);
            MemoryResultSet cachedResultSet = new MemoryResultSet((IPentahoMetaData)cachedMetaData);
            Object[] rowObjects = this.next();
            while (rowObjects != null) {
                cachedResultSet.addRow(rowObjects);
                rowObjects = this.next();
            }
            MemoryResultSet memoryResultSet = cachedResultSet;
            return memoryResultSet;
        }
        finally {
            this.close();
        }
    }

    public void beforeFirst() {
        try {
            this.index = 0;
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getErrorString("SQLResultSet.ERROR_0003_BEFORE_FIRST"), (Throwable)e);
        }
    }

    public Object[] getDataColumn(int column) {
        Object[] result = null;
        result = new Object[this.getRowCount()];
        for (int row = 0; row < result.length; ++row) {
            result[row] = this.getValueAt(row, column);
        }
        return result;
    }

    public Object[] getDataRow(int row) {
        Object[] rowData = new Object[this.getColumnCount()];
        for (int column = 0; column < rowData.length; ++column) {
            rowData[column] = this.getValueAt(row, column);
        }
        return rowData;
    }
}

