/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;

public class PentahoSystemDriver
implements Driver {
    private static final String JDBC = "jdbc:";

    List<Driver> getAllDrivers() {
        try {
            return PentahoSystem.getAll(Driver.class);
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    Map<String, String> getTranslationMap() {
        try {
            return (Map)PentahoSystem.get(Map.class, (String)"jdbcDriverTranslationMap", (IPentahoSession)PentahoSessionHolder.getSession());
        }
        catch (Throwable t) {
            return Collections.emptyMap();
        }
    }

    private String translate(String url) {
        String initial;
        Map<String, String> translationMap = this.getTranslationMap();
        if (translationMap != null && url.startsWith(JDBC) && translationMap.containsKey(initial = url.substring(5, url.indexOf(":", 5)))) {
            return url.replace(JDBC + initial, JDBC + translationMap.get(initial));
        }
        return url;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String translatedUrl = this.translate(url);
        for (Driver driver : this.getAllDrivers()) {
            Connection conn;
            if (!driver.acceptsURL(translatedUrl) || (conn = driver.connect(translatedUrl, info)) == null) continue;
            return conn;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        String translatedUrl = this.translate(url);
        for (Driver driver : this.getAllDrivers()) {
            if (!driver.acceptsURL(translatedUrl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        String translatedUrl = this.translate(url);
        for (Driver driver : this.getAllDrivers()) {
            if (!driver.acceptsURL(translatedUrl)) continue;
            return driver.getPropertyInfo(translatedUrl, info);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Impossible to know which Driver to fetch the logger from");
    }

    static {
        try {
            DriverManager.registerDriver(new PentahoSystemDriver());
        }
        catch (SQLException e) {
            org.pentaho.platform.util.logging.Logger.warn((String)PentahoSystemDriver.class.getName(), (String)Messages.getInstance().getErrorString("PentahoSystemDriver.ERROR_0001_COULD_NOT_REGISTER_DRIVER"), (Throwable)e);
        }
    }
}

