/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.mapper.MondrianAbstractPlatformUserRoleMapper;
import org.springframework.beans.factory.InitializingBean;

public class MondrianOneToOneUserRoleListMapper
extends MondrianAbstractPlatformUserRoleMapper
implements InitializingBean {
    protected boolean failOnEmptyRoleList = true;

    @Override
    protected String[] mapRoles(String[] mondrianRoles, String[] platformRoles) throws PentahoAccessControlException {
        ArrayList<String> rtnRoles = new ArrayList<String>();
        for (int i = 0; i < platformRoles.length; ++i) {
            int posn = Arrays.binarySearch(mondrianRoles, platformRoles[i]);
            if (posn < 0) continue;
            rtnRoles.add(mondrianRoles[posn]);
        }
        if (rtnRoles.size() > 0) {
            return rtnRoles.toArray(new String[rtnRoles.size()]);
        }
        if (this.failOnEmptyRoleList) {
            throw new PentahoAccessControlException(Messages.getInstance().getErrorString("MondrianOneToOneUserRoleListMapper.ERROR_001_NO_CORRESPONDENCE"));
        }
        return null;
    }

    public void setFailOnEmptyRoleList(boolean failOnEmptyRoleList) {
        this.failOnEmptyRoleList = failOnEmptyRoleList;
    }

    public boolean isFailOnEmptyRoleList() {
        return this.failOnEmptyRoleList;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

