/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mondrian;

import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.mdx.MDXLookupRule;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;

public class MondrianFlushCacheComponent
extends ComponentBase {
    private static final long serialVersionUID = 5697771680582241114L;
    private static final Log logger = LogFactory.getLog(MondrianFlushCacheComponent.class);

    public boolean executeAction() {
        Cube[] cubes;
        MDXLookupRule mdxLookupRule = this.getLookupRule();
        Connection conn = ((MDXConnection)mdxLookupRule.shareConnection()).getConnection();
        CacheControl cacheControl = conn.getCacheControl(null);
        for (Cube cube : cubes = conn.getSchema().getCubes()) {
            cacheControl.flush(cacheControl.createMeasuresRegion(cube));
        }
        cacheControl.flushSchema(conn.getSchema());
        return true;
    }

    protected boolean validateAction() {
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    public boolean init() {
        return true;
    }

    public Log getLogger() {
        return logger;
    }

    public MDXLookupRule getLookupRule() {
        return (MDXLookupRule)((Object)this.getInputValue("shared_olap_connection"));
    }
}

