/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pentaho.di.core.logging.KettleLogLayout;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.platform.api.util.LogUtil;

public class Log4jForwardingKettleLoggingEventListener
implements KettleLoggingEventListener {
    public static final String STRING_PENTAHO_DI_LOGGER_NAME = "org.pentaho.di";
    private Logger pentahoLogger = LogManager.getLogger((String)"org.pentaho.di");
    private KettleLogLayout layout;

    public Log4jForwardingKettleLoggingEventListener() {
        LogUtil.setLevel((Logger)this.pentahoLogger, (Level)Level.ALL);
        this.layout = new KettleLogLayout(true);
    }

    public void eventAdded(KettleLoggingEvent event) {
        if (event.getLevel() == LogLevel.NOTHING) {
            return;
        }
        String line = this.layout.format(event);
        switch (event.getLevel()) {
            case ERROR: {
                this.pentahoLogger.log(Level.ERROR, line);
                break;
            }
            case DEBUG: 
            case ROWLEVEL: {
                this.pentahoLogger.log(Level.DEBUG, line);
                break;
            }
            default: {
                this.pentahoLogger.log(Level.INFO, line);
            }
        }
    }
}

