/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.JavascriptAction;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.condition.javascript.RhinoScriptable;
import org.pentaho.platform.plugin.services.connections.javascript.JavaScriptResultSet;

public class JavascriptRule
extends ComponentBase {
    private static final long serialVersionUID = -8305132222755452461L;
    private boolean oldStyleOutputs;

    public Log getLogger() {
        return LogFactory.getLog(JavascriptRule.class);
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        boolean actionValidated = true;
        JavascriptAction jscriptAction = null;
        if (this.getActionDefinition() instanceof JavascriptAction) {
            IActionOutput[] outputs;
            jscriptAction = (JavascriptAction)this.getActionDefinition();
            if (jscriptAction.getScript() == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getInstance().getErrorString("JSRULE.ERROR_0001_SCRIPT_NOT_DEFINED", new Object[]{this.getActionName()}));
                actionValidated = false;
            }
            if (actionValidated && jscriptAction.getOutputs().length <= 0) {
                this.error(Messages.getInstance().getString("Template.ERROR_0002_OUTPUT_COUNT_WRONG"));
                actionValidated = false;
            }
            if (actionValidated && (outputs = jscriptAction.getOutputs()).length > 1 && jscriptAction.getInput("output1") != ActionInputConstant.NULL_INPUT) {
                this.oldStyleOutputs = true;
                for (int i = 1; i <= outputs.length; ++i) {
                    if (jscriptAction.getInput("output" + i) != ActionInputConstant.NULL_INPUT) continue;
                    this.error(Messages.getInstance().getErrorString("JavascriptRule.ERROR_0006_NO_MAPPED_OUTPUTS", new Object[]{String.valueOf(outputs.length), String.valueOf(i)}));
                    actionValidated = false;
                    break;
                }
            }
        } else {
            actionValidated = false;
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
        }
        return actionValidated;
    }

    public void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeAction() {
        boolean success;
        block24: {
            Context cx = ContextFactory.getGlobal().enterContext();
            StringBuffer buffer = new StringBuffer();
            Iterator iter = this.getResourceNames().iterator();
            while (iter.hasNext()) {
                IActionSequenceResource resource = this.getResource(((String)iter.next()).toString());
                if (!"text/javascript".equalsIgnoreCase(resource.getMimeType())) continue;
                buffer.append(this.getResourceAsString(resource));
            }
            ArrayList<String> outputNames = new ArrayList<String>();
            JavascriptAction jscriptAction = (JavascriptAction)this.getActionDefinition();
            IActionOutput[] actionOutputs = jscriptAction.getOutputs();
            if (actionOutputs.length == 1) {
                String outputName = actionOutputs[0].getName();
                outputNames.add(outputName);
            } else if (this.oldStyleOutputs) {
                int i = 1;
                while (jscriptAction.getInput("output" + i) != ActionInputConstant.NULL_INPUT) {
                    outputNames.add(jscriptAction.getInput("output" + i).getStringValue());
                    ++i;
                }
            } else {
                for (IActionOutput element : actionOutputs) {
                    outputNames.add(element.getName());
                }
            }
            success = false;
            try {
                String script = jscriptAction.getScript().getStringValue();
                if (script == null) {
                    this.error(Messages.getInstance().getErrorString("JSRULE.ERROR_0001_SCRIPT_NOT_DEFINED", new Object[]{this.getActionName()}));
                    break block24;
                }
                buffer.append(script);
                script = buffer.toString();
                this.debug("script=" + script);
                try {
                    RhinoScriptable scriptable = new RhinoScriptable();
                    Scriptable scope = cx.initStandardObjects((ScriptableObject)scriptable);
                    Object resultObject = this.executeScript(scriptable, scope, script, cx);
                    if (this.oldStyleOutputs) {
                        if (resultObject instanceof NativeArray) {
                            NativeArray jsArray = (NativeArray)resultObject;
                            int length = (int)jsArray.getLength();
                            for (int i = 0; i < length; ++i) {
                                Object value = jsArray.get(i, (Scriptable)scriptable);
                                if (i < outputNames.size()) {
                                    jscriptAction.getOutput(((String)outputNames.get(i)).toString()).setValue(this.convertWrappedJavaObject(value));
                                    continue;
                                }
                                break;
                            }
                        } else {
                            jscriptAction.getOutput(((String)outputNames.get(0)).toString()).setValue(this.convertWrappedJavaObject(resultObject));
                        }
                    } else if (outputNames.size() == 1 && resultObject != null) {
                        jscriptAction.getOutput(((String)outputNames.get(0)).toString()).setValue(this.convertWrappedJavaObject(resultObject));
                    } else {
                        Object[] ids;
                        ArrayList<String> setOutputs = new ArrayList<String>(outputNames.size());
                        for (Object element : ids = ScriptableObject.getPropertyIds((Scriptable)scope)) {
                            int idx = outputNames.indexOf(element.toString());
                            if (idx < 0) continue;
                            jscriptAction.getOutput(((String)outputNames.get(idx)).toString()).setValue(this.convertWrappedJavaObject(ScriptableObject.getProperty((Scriptable)scope, (String)((String)element))));
                            setOutputs.add((String)outputNames.get(idx));
                        }
                        if (setOutputs.size() != outputNames.size()) {
                            for (int i = 0; i < outputNames.size(); ++i) {
                                if (setOutputs.indexOf(outputNames.get(i)) >= 0) continue;
                                jscriptAction.getOutput(((String)outputNames.get(i)).toString()).setValue(null);
                            }
                        }
                    }
                    success = true;
                }
                catch (Exception e) {
                    this.error(Messages.getInstance().getErrorString("JSRULE.ERROR_0003_EXECUTION_FAILED"), e);
                }
            }
            finally {
                Context.exit();
            }
        }
        return success;
    }

    protected Object executeScript(ScriptableObject scriptable, Scriptable scope, String script, Context cx) throws Exception {
        ScriptableObject.defineClass((Scriptable)scope, JavaScriptResultSet.class);
        Set inputNames = this.getInputNames();
        for (String inputName : inputNames) {
            Object wrapper;
            if (inputName.indexOf(45) >= 0) {
                throw new IllegalArgumentException(Messages.getInstance().getErrorString("JSRULE.ERROR_0006_INVALID_JS_VARIABLE", new Object[]{inputName}));
            }
            Object inputValue = this.getInputValue(inputName);
            if (inputValue instanceof String) {
                inputValue = StringEscapeUtils.escapeHtml((String)((String)inputValue));
            }
            if (inputValue instanceof IPentahoResultSet) {
                JavaScriptResultSet results = new JavaScriptResultSet();
                results.setPrototype((Scriptable)scriptable);
                results.setResultSet((IPentahoResultSet)inputValue);
                wrapper = Context.javaToJS((Object)inputValue, (Scriptable)results);
            } else {
                wrapper = Context.javaToJS((Object)inputValue, (Scriptable)scope);
            }
            ScriptableObject.putProperty((Scriptable)scope, (String)inputName, (Object)wrapper);
        }
        Object wrappedOut = Context.javaToJS((Object)System.out, (Scriptable)scope);
        Object wrappedThis = Context.javaToJS((Object)((Object)this), (Scriptable)scope);
        ScriptableObject.putProperty((Scriptable)scope, (String)"out", (Object)wrappedOut);
        ScriptableObject.putProperty((Scriptable)scope, (String)"rule", (Object)wrappedThis);
        return cx.evaluateString(scope, script, "<cmd>", 1, null);
    }

    protected Object convertWrappedJavaObject(Object obj) {
        if (obj instanceof NativeJavaObject) {
            return ((NativeJavaObject)obj).unwrap();
        }
        return obj;
    }

    public boolean init() {
        return true;
    }
}

