/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.actions.SubActionAction;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.system.UserSession;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.engine.services.solution.SolutionHelper;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class SubActionComponent
extends ComponentBase {
    private static final long serialVersionUID = 3557732430102823611L;
    private static final String PATH_SEPARATOR = "/";

    public Log getLogger() {
        return LogFactory.getLog(SubActionComponent.class);
    }

    protected boolean validateAction() {
        boolean value = false;
        SubActionAction subAction = null;
        if (this.getActionDefinition() instanceof SubActionAction) {
            subAction = (SubActionAction)this.getActionDefinition();
            if (subAction.getAction() != ActionInputConstant.NULL_INPUT && subAction.getPath() != ActionInputConstant.NULL_INPUT && subAction.getSolution() != ActionInputConstant.NULL_INPUT) {
                value = true;
            } else if (subAction.getPath() != ActionInputConstant.NULL_INPUT) {
                value = true;
            }
        } else {
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
        }
        return value;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    public String buildActionPath(String solution, String path, String action) {
        String actionPath = "";
        if (!StringUtils.isEmpty((String)solution)) {
            actionPath = solution;
        }
        if (!StringUtils.isEmpty((String)path)) {
            actionPath = StringUtils.isEmpty((String)actionPath) ? path : actionPath + PATH_SEPARATOR + path;
        }
        if (!StringUtils.isEmpty((String)action)) {
            actionPath = StringUtils.isEmpty((String)actionPath) ? action : actionPath + PATH_SEPARATOR + action;
        }
        actionPath = actionPath.replace('\\', '/');
        while (actionPath.contains("//")) {
            actionPath = actionPath.replaceAll("//", PATH_SEPARATOR);
        }
        if (!StringUtils.isEmpty((String)actionPath) && !actionPath.startsWith(PATH_SEPARATOR)) {
            actionPath = PATH_SEPARATOR + actionPath;
        }
        return actionPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeAction() throws Throwable {
        SubActionAction subAction = (SubActionAction)this.getActionDefinition();
        ArrayList<Object> ignoreParameters = new ArrayList<Object>();
        String actionPath = this.buildActionPath(subAction.getSolution().getStringValue(), subAction.getPath().getStringValue(), subAction.getAction().getStringValue());
        IPentahoSession session = this.getSession();
        if (subAction.getSessionProxy() != ActionInputConstant.NULL_INPUT) {
            String sessionName = subAction.getSessionProxy().getStringValue();
            PentahoSessionParameterProvider params = new PentahoSessionParameterProvider(session);
            session = new UserSession(sessionName, LocaleHelper.getLocale(), (IParameterProvider)params);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (String inputName : this.getInputNames()) {
            if ("solution".equals(inputName) || "path".equals(inputName) || "action".equals(inputName)) continue;
            Object value = this.getInputValue(inputName);
            ignoreParameters.add(value);
            parameters.put(inputName, value);
        }
        parameters.put("action-url-component", this.getInputStringValue("action-url-component"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISolutionEngine solutionEngine = null;
        try {
            int status;
            solutionEngine = SolutionHelper.execute((String)this.getProcessId(), (IPentahoSession)session, (String)actionPath, parameters, (OutputStream)outputStream, null, (boolean)true, (boolean)false);
            if (outputStream.size() > 0) {
                this.getDefaultOutputStream(null).write(outputStream.toByteArray());
            }
            if ((status = solutionEngine.getStatus()) == 6) {
                for (String outputName : this.getOutputNames()) {
                    IActionParameter param = solutionEngine.getExecutionContext().getOutputParameter(outputName);
                    if (param == null) continue;
                    this.setOutputValue(outputName, param.getValue());
                    ignoreParameters.add(param.getValue());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (solutionEngine != null) {
                solutionEngine.getExecutionContext().dispose(ignoreParameters);
            }
        }
    }

    public boolean init() {
        return true;
    }
}

