/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig
implements ISystemConfig {
    private static final Pattern pattern = Pattern.compile("([^.]+)\\.(.+)");
    private static final Logger logger = LoggerFactory.getLogger(SystemConfig.class);
    private final Map<String, IConfiguration> configs = new ConcurrentHashMap<String, IConfiguration>();

    public SystemConfig() {
    }

    public SystemConfig(List<IConfiguration> startingConfigs) throws IOException {
        for (IConfiguration startingConfig : startingConfigs) {
            this.registerConfiguration(startingConfig);
        }
    }

    public String getProperty(String placeholder) {
        if (!pattern.matcher(placeholder).matches()) {
            throw new IllegalArgumentException("property does not follow the pattern ID.PROP");
        }
        return this.resolveValue(placeholder);
    }

    private String resolveValue(String placeholder) {
        Matcher matcher = pattern.matcher(placeholder);
        matcher.find();
        String pid = matcher.group(1);
        String key = matcher.group(2);
        IConfiguration con = this.getConfiguration(pid);
        if (con == null) {
            logger.info("Error resolving key replacement: " + placeholder);
            return null;
        }
        try {
            return con.getProperties().getProperty(key);
        }
        catch (IOException e) {
            logger.error("Error getting properties for configuration: " + key);
            return null;
        }
    }

    public IConfiguration getConfiguration(String configId) {
        return this.configs.get(configId);
    }

    public void registerConfiguration(IConfiguration configuration) throws IOException {
        String configId = configuration.getId();
        if (configId == null) {
            throw new IllegalStateException("Config id is null");
        }
        try {
            this.configs.compute(configId, (key, existingConfig) -> {
                if (existingConfig == null) {
                    return configuration;
                }
                try {
                    if (existingConfig instanceof CompositeConfiguration) {
                        ((CompositeConfiguration)existingConfig).addConfiguration(configuration);
                        return existingConfig;
                    }
                    CompositeConfiguration composite = new CompositeConfiguration((String)key);
                    composite.addConfiguration((IConfiguration)existingConfig);
                    composite.addConfiguration(configuration);
                    return composite;
                }
                catch (IOException e) {
                    throw new WrappedIOException(e);
                }
            });
        }
        catch (WrappedIOException wrapped) {
            throw wrapped.getCause();
        }
    }

    public IConfiguration[] listConfigurations() {
        Collection<IConfiguration> entries = this.configs.values();
        return entries.toArray(new IConfiguration[entries.size()]);
    }

    private static class CompositeConfiguration
    implements IConfiguration {
        private final String id;
        private final Properties properties;

        public CompositeConfiguration(String id) {
            Objects.requireNonNull(id);
            this.id = id;
            this.properties = new Properties();
        }

        public String getId() {
            return this.id;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void addConfiguration(IConfiguration configuration) throws IOException {
            Objects.requireNonNull(configuration);
            this.properties.putAll((Map<?, ?>)configuration.getProperties());
        }

        public void update(Properties addProperties) throws IOException {
            throw new UnsupportedOperationException("CompositeConfiguration does not support write-back");
        }
    }

    private static class WrappedIOException
    extends RuntimeException {
        public WrappedIOException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

