/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileTree;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.ClientRepositoryPaths;

public class GeneratedContentCleaner
implements IAction {
    private static final Log logger = LogFactory.getLog(GeneratedContentCleaner.class);
    private long age = 15552000000L;
    private IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);

    private void findGeneratedContent(List<RepositoryFile> generatedContentList, RepositoryFileTree parent) {
        block2: {
            block1: {
                RepositoryFile parentFile = parent.getFile();
                if (parentFile.isFolder()) break block1;
                long createTime = parentFile.getCreatedDate().getTime();
                logger.debug((Object)("checking: " + parentFile.getPath() + "   " + createTime));
                if (createTime > System.currentTimeMillis() - this.age) break block2;
                logger.debug((Object)"File passes age criteria");
                Map metadata = this.repository.getFileMetadata(parentFile.getId());
                if (!metadata.containsKey("lineage-id")) break block2;
                logger.debug((Object)"File is generated content - adding to delete list");
                generatedContentList.add(parentFile);
                break block2;
            }
            for (RepositoryFileTree child : parent.getChildren()) {
                this.findGeneratedContent(generatedContentList, child);
            }
        }
    }

    public void execute() throws Exception {
        RepositoryFileTree tree = this.repository.getTree(ClientRepositoryPaths.getRootFolderPath(), -1, null, true);
        ArrayList<RepositoryFile> generatedContentList = new ArrayList<RepositoryFile>();
        this.findGeneratedContent(generatedContentList, tree);
        for (RepositoryFile deleteMe : generatedContentList) {
            this.repository.deleteFile(deleteMe.getId(), true, GeneratedContentCleaner.class.getName());
            logger.info((Object)("GeneratedContentCleaner deleting: " + deleteMe.getPath()));
        }
    }

    public long getAge() {
        return this.age;
    }

    public void setAge(long age) {
        this.age = age;
    }
}

