/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.servicecoordination.impl;

import java.util.concurrent.CountDownLatch;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleEvent;
import org.pentaho.platform.servicecoordination.api.IPhasedLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountdownLatchLifecycleEvent<T>
implements IPhasedLifecycleEvent<T> {
    private int phase;
    private T notificationObject;
    private CountDownLatch latch;
    private IPhasedLifecycleManager<T> manager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CountdownLatchLifecycleEvent(int phase, T notificationObject, CountDownLatch latch, IPhasedLifecycleManager<T> manager) {
        this.phase = phase;
        this.notificationObject = notificationObject;
        this.latch = latch;
        this.manager = manager;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public T getNotificationObject() {
        return this.notificationObject;
    }

    @Override
    public void accept() {
        this.latch.countDown();
    }

    @Override
    public void exception(Throwable t) {
        this.logger.error("Error processing Lifecycle Event", t);
        this.manager.terminate();
    }
}

