/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.googledrive.lifecycle;

import java.io.File;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.pentaho.di.core.annotations.LifecyclePlugin;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.googledrive.vfs.GoogleDriveFileObject;
import org.pentaho.googledrive.vfs.ui.GoogleDriveFileChooserDialog;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

@LifecyclePlugin(id="GoogleDriveKettleLifecycleListener", name="GoogleDriveKettleLifecycleListener")
public class GoogleDriveKettleLifecycleListener
implements LifecycleListener {
    private ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("plugin");

    public void onStart(LifeEventHandler handler) throws LifecycleException {
        if (new File(GoogleDriveFileObject.resolveCredentialsPath() + "/" + this.resourceBundle.getString("client.secrets")).exists()) {
            final Spoon spoon = Spoon.getInstance();
            spoon.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    VfsFileChooserDialog dialog = spoon.getVfsFileChooserDialog(null, null);
                    GoogleDriveFileChooserDialog hadoopVfsFileChooserDialog = new GoogleDriveFileChooserDialog("googledrive", "Google Drive", dialog, 0);
                    dialog.addVFSUIPanel((CustomVfsUiPanel)hadoopVfsFileChooserDialog);
                }
            });
        }
    }

    public void onExit(LifeEventHandler handler) throws LifecycleException {
    }
}

