/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class StoreFileInfo {
    private static final Log LOG = LogFactory.getLog(StoreFileInfo.class);
    public static final String HFILE_NAME_REGEX = "[0-9a-f]+(?:_SeqId_[0-9]+_)?";
    private static final Pattern HFILE_NAME_PATTERN = Pattern.compile("^([0-9a-f]+(?:_SeqId_[0-9]+_)?)");
    private static final Pattern REF_NAME_PATTERN = Pattern.compile(String.format("^(%s|%s)\\.(.+)$", "[0-9a-f]+(?:_SeqId_[0-9]+_)?", HFileLink.LINK_NAME_REGEX));
    private Configuration conf;
    private final FileSystem fs;
    private HDFSBlocksDistribution hdfsBlocksDistribution = null;
    private final Reference reference;
    private final HFileLink link;
    private final Path initialPath;
    private RegionCoprocessorHost coprocessorHost;
    private long createdTimestamp;

    public StoreFileInfo(Configuration conf, FileSystem fs, Path initialPath) throws IOException {
        assert (fs != null);
        assert (initialPath != null);
        assert (conf != null);
        this.fs = fs;
        this.conf = conf;
        this.initialPath = initialPath;
        Path p = initialPath;
        if (HFileLink.isHFileLink(p)) {
            this.reference = null;
            this.link = HFileLink.buildFromHFileLinkPattern(conf, p);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(p + " is a link"));
            }
        } else if (StoreFileInfo.isReference(p)) {
            this.reference = Reference.read(fs, p);
            Path referencePath = StoreFileInfo.getReferredToFile(p);
            this.link = HFileLink.isHFileLink(referencePath) ? HFileLink.buildFromHFileLinkPattern(conf, referencePath) : null;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(p + " is a " + (Object)((Object)this.reference.getFileRegion()) + " reference to " + referencePath));
            }
        } else if (StoreFileInfo.isHFile(p)) {
            this.createdTimestamp = fs.getFileStatus(initialPath).getModificationTime();
            this.reference = null;
            this.link = null;
        } else {
            throw new IOException("path=" + p + " doesn't look like a valid StoreFile");
        }
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus) throws IOException {
        this(conf, fs, fileStatus.getPath());
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, HFileLink link) throws IOException {
        this.fs = fs;
        this.conf = conf;
        this.initialPath = fileStatus == null ? null : fileStatus.getPath();
        this.reference = null;
        this.link = link;
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Reference reference) throws IOException {
        this.fs = fs;
        this.conf = conf;
        this.initialPath = fileStatus.getPath();
        this.createdTimestamp = fileStatus.getModificationTime();
        this.reference = reference;
        this.link = null;
    }

    public void setRegionCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public boolean isTopReference() {
        return this.reference != null && Reference.isTopFileRegion(this.reference.getFileRegion());
    }

    public boolean isLink() {
        return this.link != null && this.reference == null;
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    public StoreFile.Reader open(FileSystem fs, CacheConfig cacheConf, boolean canUseDropBehind) throws IOException {
        FileStatus status;
        FSDataInputStreamWrapper in;
        boolean doDropBehind;
        boolean bl = doDropBehind = canUseDropBehind && cacheConf.shouldDropBehindCompaction();
        if (this.link != null) {
            in = new FSDataInputStreamWrapper(fs, this.link, doDropBehind);
            status = this.link.getFileStatus(fs);
        } else if (this.reference != null) {
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            in = new FSDataInputStreamWrapper(fs, referencePath, doDropBehind);
            status = fs.getFileStatus(referencePath);
        } else {
            in = new FSDataInputStreamWrapper(fs, this.getPath(), doDropBehind);
            status = fs.getFileStatus(this.initialPath);
        }
        long length = status.getLen();
        this.hdfsBlocksDistribution = this.computeHDFSBlocksDistribution(fs);
        StoreFile.Reader reader = null;
        if (this.coprocessorHost != null) {
            reader = this.coprocessorHost.preStoreFileReaderOpen(fs, this.getPath(), in, length, cacheConf, this.reference);
        }
        if (reader == null) {
            reader = this.reference != null ? new HalfStoreFileReader(fs, this.getPath(), in, length, cacheConf, this.reference, this.conf) : new StoreFile.Reader(fs, status.getPath(), in, length, cacheConf, this.conf);
        }
        if (this.coprocessorHost != null) {
            reader = this.coprocessorHost.postStoreFileReaderOpen(fs, this.getPath(), in, length, cacheConf, this.reference, reader);
        }
        return reader;
    }

    public HDFSBlocksDistribution computeHDFSBlocksDistribution(FileSystem fs) throws IOException {
        if (this.link != null) {
            FileNotFoundException exToThrow = null;
            for (int i = 0; i < this.link.getLocations().length; ++i) {
                try {
                    return this.computeHDFSBlocksDistributionInternal(fs);
                }
                catch (FileNotFoundException ex) {
                    exToThrow = ex;
                    continue;
                }
            }
            throw exToThrow;
        }
        return this.computeHDFSBlocksDistributionInternal(fs);
    }

    private HDFSBlocksDistribution computeHDFSBlocksDistributionInternal(FileSystem fs) throws IOException {
        FileStatus status = this.getReferencedFileStatus(fs);
        if (this.reference != null) {
            return StoreFileInfo.computeRefFileHDFSBlockDistribution(fs, this.reference, status);
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, 0L, status.getLen());
    }

    public FileStatus getReferencedFileStatus(FileSystem fs) throws IOException {
        FileStatus status;
        if (this.reference != null) {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            status = fs.getFileStatus(referencePath);
        } else {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            status = fs.getFileStatus(this.initialPath);
        }
        return status;
    }

    public Path getPath() {
        return this.initialPath;
    }

    public FileStatus getFileStatus() throws IOException {
        return this.getReferencedFileStatus(this.fs);
    }

    public long getModificationTime() throws IOException {
        return this.getFileStatus().getModificationTime();
    }

    public String toString() {
        return this.getPath() + (this.isReference() ? "-" + StoreFileInfo.getReferredToFile(this.getPath()) + "-" + this.reference : "");
    }

    public static boolean isHFile(Path path) {
        return StoreFileInfo.isHFile(path.getName());
    }

    public static boolean isHFile(String fileName) {
        Matcher m = HFILE_NAME_PATTERN.matcher(fileName);
        return m.matches() && m.groupCount() > 0;
    }

    public static boolean isReference(Path path) {
        return StoreFileInfo.isReference(path.getName());
    }

    public static boolean isReference(String name) {
        Matcher m = REF_NAME_PATTERN.matcher(name);
        return m.matches() && m.groupCount() > 1;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public static Path getReferredToFile(Path p) {
        Matcher m = REF_NAME_PATTERN.matcher(p.getName());
        if (m == null || !m.matches()) {
            LOG.warn((Object)("Failed match of store file name " + p.toString()));
            throw new IllegalArgumentException("Failed match of store file name " + p.toString());
        }
        String otherRegion = m.group(2);
        Path tableDir = p.getParent().getParent().getParent();
        String nameStrippedOfSuffix = m.group(1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reference '" + p + "' to region=" + otherRegion + " hfile=" + nameStrippedOfSuffix));
        }
        return new Path(new Path(new Path(tableDir, otherRegion), p.getParent().getName()), nameStrippedOfSuffix);
    }

    public static boolean validateStoreFileName(String fileName) {
        if (HFileLink.isHFileLink(fileName) || StoreFileInfo.isReference(fileName)) {
            return true;
        }
        return !fileName.contains("-");
    }

    public static boolean isValid(FileStatus fileStatus) throws IOException {
        Path p = fileStatus.getPath();
        if (fileStatus.isDirectory()) {
            return false;
        }
        if (!HFileLink.isHFileLink(p) && fileStatus.getLen() <= 0L) {
            LOG.warn((Object)("Skipping " + p + " because it is empty. HBASE-646 DATA LOSS?"));
            return false;
        }
        return StoreFileInfo.validateStoreFileName(p.getName());
    }

    private static HDFSBlocksDistribution computeRefFileHDFSBlockDistribution(FileSystem fs, Reference reference, FileStatus status) throws IOException {
        if (status == null) {
            return null;
        }
        long start = 0L;
        long length = 0L;
        if (Reference.isTopFileRegion(reference.getFileRegion())) {
            start = status.getLen() / 2L;
            length = status.getLen() - status.getLen() / 2L;
        } else {
            start = 0L;
            length = status.getLen() / 2L;
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, start, length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.initialPath == null ? 0 : this.initialPath.hashCode());
        result = 31 * result + (this.link == null ? 0 : this.link.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreFileInfo other = (StoreFileInfo)obj;
        if (this.initialPath == null ? other.initialPath != null : !this.initialPath.equals((Object)other.initialPath)) {
            return false;
        }
        if (this.link == null ? other.link != null : !this.link.equals(other.link)) {
            return false;
        }
        return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
    }
}

