/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.CellCreator;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TsvImporterMapper
extends Mapper<LongWritable, Text, ImmutableBytesWritable, Put> {
    protected long ts;
    private String separator;
    private boolean skipBadLines;
    private boolean skipEmptyColumns;
    private Counter badLineCount;
    private boolean logBadLines;
    protected ImportTsv.TsvParser parser;
    protected Configuration conf;
    protected String cellVisibilityExpr;
    protected long ttl;
    protected CellCreator kvCreator;
    private String hfileOutPath;

    public long getTs() {
        return this.ts;
    }

    public boolean getSkipBadLines() {
        return this.skipBadLines;
    }

    public Counter getBadLineCount() {
        return this.badLineCount;
    }

    public void incrementBadLineCount(int count) {
        this.badLineCount.increment((long)count);
    }

    protected void setup(Mapper.Context context) {
        this.doSetup(context);
        this.conf = context.getConfiguration();
        this.parser = new ImportTsv.TsvParser(this.conf.get("importtsv.columns"), this.separator);
        if (this.parser.getRowKeyColumnIndex() == -1) {
            throw new RuntimeException("No row key column specified");
        }
        this.kvCreator = new CellCreator(this.conf);
    }

    protected void doSetup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("importtsv.separator");
        this.separator = this.separator == null ? "\t" : new String(Base64.decode((String)this.separator));
        this.ts = conf.getLong("importtsv.timestamp", 0L);
        this.skipEmptyColumns = context.getConfiguration().getBoolean("importtsv.skip.empty.columns", false);
        this.skipBadLines = context.getConfiguration().getBoolean("importtsv.skip.bad.lines", true);
        this.badLineCount = context.getCounter("ImportTsv", "Bad Lines");
        this.logBadLines = context.getConfiguration().getBoolean("importtsv.log.bad.lines", false);
        this.hfileOutPath = conf.get("importtsv.bulk.output");
    }

    public void map(LongWritable offset, Text value, Mapper.Context context) throws IOException {
        byte[] lineBytes = value.getBytes();
        try {
            ImportTsv.TsvParser.ParsedLine parsed = this.parser.parse(lineBytes, value.getLength());
            ImmutableBytesWritable rowKey = new ImmutableBytesWritable(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength());
            this.ts = parsed.getTimestamp(this.ts);
            this.cellVisibilityExpr = parsed.getCellVisibility();
            this.ttl = parsed.getCellTTL();
            Put put = new Put(rowKey.copyBytes());
            for (int i = 0; i < parsed.getColumnCount(); ++i) {
                if (i == this.parser.getRowKeyColumnIndex() || i == this.parser.getTimestampKeyColumnIndex() || i == this.parser.getAttributesKeyColumnIndex() || i == this.parser.getCellVisibilityColumnIndex() || i == this.parser.getCellTTLColumnIndex() || this.skipEmptyColumns && parsed.getColumnLength(i) == 0) continue;
                this.populatePut(lineBytes, parsed, put, i);
            }
            context.write((Object)rowKey, (Object)put);
        }
        catch (IllegalArgumentException | ImportTsv.TsvParser.BadTsvLineException | InvalidLabelException badLine) {
            if (this.logBadLines) {
                System.err.println(value);
            }
            System.err.println("Bad line at offset: " + offset.get() + ":\n" + badLine.getMessage());
            if (this.skipBadLines) {
                this.incrementBadLineCount(1);
                return;
            }
            throw new IOException(badLine);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void populatePut(byte[] lineBytes, ImportTsv.TsvParser.ParsedLine parsed, Put put, int i) throws ImportTsv.TsvParser.BadTsvLineException, IOException {
        KeyValue cell = null;
        if (this.hfileOutPath == null) {
            cell = new KeyValue(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength(), this.parser.getFamily(i), 0, this.parser.getFamily(i).length, this.parser.getQualifier(i), 0, this.parser.getQualifier(i).length, this.ts, KeyValue.Type.Put, lineBytes, parsed.getColumnOffset(i), parsed.getColumnLength(i));
            if (this.cellVisibilityExpr != null) {
                put.setCellVisibility(new CellVisibility(this.cellVisibilityExpr));
            }
            if (this.ttl > 0L) {
                put.setTTL(this.ttl);
            }
        } else {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            if (this.cellVisibilityExpr != null) {
                tags.addAll(this.kvCreator.getVisibilityExpressionResolver().createVisibilityExpTags(this.cellVisibilityExpr));
            }
            if (this.ttl > 0L) {
                tags.add(new Tag(8, Bytes.toBytes((long)this.ttl)));
            }
            cell = this.kvCreator.create(lineBytes, parsed.getRowKeyOffset(), parsed.getRowKeyLength(), this.parser.getFamily(i), 0, this.parser.getFamily(i).length, this.parser.getQualifier(i), 0, this.parser.getQualifier(i).length, this.ts, lineBytes, parsed.getColumnOffset(i), parsed.getColumnLength(i), tags);
        }
        put.add((Cell)cell);
    }
}

