/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigFormat;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public class Serializers {
    private final CFMetaData metadata;
    private Map<Version, IndexInfo.Serializer> otherVersionClusteringSerializers;
    private final IndexInfo.Serializer latestVersionIndexSerializer;

    public Serializers(CFMetaData metadata) {
        this.metadata = metadata;
        this.latestVersionIndexSerializer = new IndexInfo.Serializer(BigFormat.latestVersion, this.indexEntryClusteringPrefixSerializer(BigFormat.latestVersion, SerializationHeader.makeWithoutStats(metadata)));
    }

    IndexInfo.Serializer indexInfoSerializer(Version version, SerializationHeader header) {
        IndexInfo.Serializer serializer;
        if (version.equals(BigFormat.latestVersion) && header != null) {
            return this.latestVersionIndexSerializer;
        }
        if (this.otherVersionClusteringSerializers == null) {
            this.otherVersionClusteringSerializers = new ConcurrentHashMap<Version, IndexInfo.Serializer>();
        }
        if ((serializer = this.otherVersionClusteringSerializers.get(version)) == null) {
            serializer = new IndexInfo.Serializer(version, this.indexEntryClusteringPrefixSerializer(version, header));
            this.otherVersionClusteringSerializers.put(version, serializer);
        }
        return serializer;
    }

    private ISerializer<ClusteringPrefix> indexEntryClusteringPrefixSerializer(Version version, SerializationHeader header) {
        if (!version.storeRows() || header == null) {
            return this.oldFormatSerializer(version);
        }
        return new NewFormatSerializer(version, header.clusteringTypes());
    }

    private ISerializer<ClusteringPrefix> oldFormatSerializer(final Version version) {
        return new ISerializer<ClusteringPrefix>(){
            List<AbstractType<?>> clusteringTypes;
            {
                this.clusteringTypes = SerializationHeader.makeWithoutStats(Serializers.this.metadata).clusteringTypes();
            }

            @Override
            public void serialize(ClusteringPrefix clustering, DataOutputPlus out) throws IOException {
                ClusteringPrefix.serializer.serialize(clustering, out, version.correspondingMessagingVersion(), this.clusteringTypes);
            }

            @Override
            public void skip(DataInputPlus in) throws IOException {
                ByteBufferUtil.skipShortLength(in);
            }

            @Override
            public ClusteringPrefix deserialize(DataInputPlus in) throws IOException {
                ByteBuffer bb = ByteBufferUtil.readWithShortLength(in);
                assert (bb.hasRemaining());
                int clusteringSize = Serializers.this.metadata.clusteringColumns().size();
                if (clusteringSize == 0) {
                    return Clustering.EMPTY;
                }
                if (!Serializers.this.metadata.isCompound()) {
                    return Clustering.make(bb);
                }
                List<ByteBuffer> components = CompositeType.splitName(bb);
                byte eoc = CompositeType.lastEOC(bb);
                if (eoc == 0 || components.size() >= clusteringSize) {
                    if (components.size() > clusteringSize) {
                        components = components.subList(0, clusteringSize);
                    }
                    return Clustering.make(components.toArray(new ByteBuffer[clusteringSize]));
                }
                ClusteringPrefix.Kind boundKind = eoc > 0 ? ClusteringPrefix.Kind.EXCL_START_BOUND : ClusteringPrefix.Kind.INCL_START_BOUND;
                return ClusteringBound.create(boundKind, components.toArray(new ByteBuffer[components.size()]));
            }

            @Override
            public long serializedSize(ClusteringPrefix clustering) {
                return ClusteringPrefix.serializer.serializedSize(clustering, version.correspondingMessagingVersion(), this.clusteringTypes);
            }
        };
    }

    private static class NewFormatSerializer
    implements ISerializer<ClusteringPrefix> {
        private final Version version;
        private final List<AbstractType<?>> clusteringTypes;

        NewFormatSerializer(Version version, List<AbstractType<?>> clusteringTypes) {
            this.version = version;
            this.clusteringTypes = clusteringTypes;
        }

        @Override
        public void serialize(ClusteringPrefix clustering, DataOutputPlus out) throws IOException {
            ClusteringPrefix.serializer.serialize(clustering, out, this.version.correspondingMessagingVersion(), this.clusteringTypes);
        }

        @Override
        public void skip(DataInputPlus in) throws IOException {
            ClusteringPrefix.serializer.skip(in, this.version.correspondingMessagingVersion(), this.clusteringTypes);
        }

        @Override
        public ClusteringPrefix deserialize(DataInputPlus in) throws IOException {
            return ClusteringPrefix.serializer.deserialize(in, this.version.correspondingMessagingVersion(), this.clusteringTypes);
        }

        @Override
        public long serializedSize(ClusteringPrefix clustering) {
            return ClusteringPrefix.serializer.serializedSize(clustering, this.version.correspondingMessagingVersion(), this.clusteringTypes);
        }
    }
}

