/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.model;

import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.util.NullIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractType {
    private QName name;
    private JavaType javaType;
    private String version = null;
    private Map properties;

    protected AbstractType() {
    }

    protected AbstractType(QName name) {
        this(name, null, null);
    }

    protected AbstractType(QName name, String version) {
        this(name, null, version);
    }

    protected AbstractType(QName name, JavaType javaType) {
        this(name, javaType, null);
    }

    protected AbstractType(QName name, JavaType javaType, String version) {
        this.name = name;
        this.javaType = javaType;
        this.version = version;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public void setJavaType(JavaType javaType) {
        this.javaType = javaType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isNillable() {
        return false;
    }

    public boolean isSOAPType() {
        return false;
    }

    public boolean isLiteralType() {
        return false;
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.removeProperty(key);
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    public Iterator getProperties() {
        if (this.properties == null) {
            return NullIterator.getInstance();
        }
        return this.properties.keySet().iterator();
    }

    public Map getPropertiesMap() {
        return this.properties;
    }

    public void setPropertiesMap(Map m) {
        this.properties = m;
    }
}

