/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.s3common.S3CommonFileInputStream;
import org.pentaho.s3common.S3CommonFileSystem;
import org.pentaho.s3common.S3CommonPipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3CommonFileObject
extends AbstractFileObject {
    private static final Logger logger = LoggerFactory.getLogger(S3CommonFileObject.class);
    public static final String DELIMITER = "/";
    protected S3CommonFileSystem fileSystem;
    protected String bucketName;
    protected String key;
    protected S3Object s3Object;
    protected ObjectMetadata s3ObjectMetadata;

    protected S3CommonFileObject(AbstractFileName name, S3CommonFileSystem fileSystem) {
        super(name, (AbstractFileSystem)fileSystem);
        this.fileSystem = fileSystem;
        this.bucketName = this.getS3BucketName();
        this.key = this.getBucketRelativeS3Path();
    }

    protected long doGetContentSize() {
        return this.s3ObjectMetadata.getContentLength();
    }

    protected InputStream doGetInputStream() throws Exception {
        logger.debug("Accessing content {}", (Object)this.getQualifiedName());
        this.closeS3Object();
        S3Object streamS3Object = this.getS3Object();
        return new S3CommonFileInputStream((InputStream)streamS3Object.getObjectContent(), streamS3Object);
    }

    protected FileType doGetType() throws Exception {
        return this.getType();
    }

    protected String[] doListChildren() throws Exception {
        List<Object> childrenList = new ArrayList();
        if (this.getType() == FileType.FOLDER || this.isRootBucket()) {
            childrenList = this.getS3ObjectsFromVirtualFolder(this.key, this.bucketName);
        }
        String[] childrenArr = new String[childrenList.size()];
        return childrenList.toArray(childrenArr);
    }

    protected String getS3BucketName() {
        String bucket = this.getName().getPath();
        bucket = bucket.indexOf(DELIMITER, 1) > 1 ? bucket.substring(1, bucket.indexOf(DELIMITER, 1)) : bucket.replace(DELIMITER, "");
        return bucket;
    }

    protected List<String> getS3ObjectsFromVirtualFolder(String key, String bucketName) {
        ArrayList<String> childrenList = new ArrayList<String>();
        String realKey = key;
        if (!realKey.endsWith(DELIMITER)) {
            realKey = realKey + DELIMITER;
        }
        if ("".equals(key) && "".equals(bucketName)) {
            List bucketList = this.fileSystem.getS3Client().listBuckets();
            for (Bucket bucket : bucketList) {
                childrenList.add(bucket.getName() + DELIMITER);
            }
        } else {
            this.getObjectsFromNonRootFolder(key, bucketName, childrenList, realKey);
        }
        return childrenList;
    }

    private void getObjectsFromNonRootFolder(String key, String bucketName, List<String> childrenList, String realKey) {
        String prefix = key.isEmpty() || key.endsWith(DELIMITER) ? key : key + DELIMITER;
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(DELIMITER);
        ObjectListing ol = this.fileSystem.getS3Client().listObjects(listObjectsRequest);
        ArrayList allSummaries = new ArrayList(ol.getObjectSummaries());
        ArrayList allCommonPrefixes = new ArrayList(ol.getCommonPrefixes());
        while (ol.isTruncated()) {
            ol = this.fileSystem.getS3Client().listNextBatchOfObjects(ol);
            allSummaries.addAll(ol.getObjectSummaries());
            allCommonPrefixes.addAll(ol.getCommonPrefixes());
        }
        for (S3ObjectSummary s3os : allSummaries) {
            if (s3os.getKey().equals(realKey)) continue;
            childrenList.add(s3os.getKey().substring(prefix.length()));
        }
        for (String commonPrefix : allCommonPrefixes) {
            if (commonPrefix.equals(realKey)) continue;
            childrenList.add(commonPrefix.substring(prefix.length()));
        }
    }

    protected String getBucketRelativeS3Path() {
        if (this.getName().getPath().indexOf(DELIMITER, 1) >= 0) {
            return this.getName().getPath().substring(this.getName().getPath().indexOf(DELIMITER, 1) + 1);
        }
        return "";
    }

    @VisibleForTesting
    public S3Object getS3Object() {
        return this.getS3Object(this.key, this.bucketName);
    }

    protected S3Object getS3Object(String key, String bucket) {
        if (this.s3Object != null && this.s3Object.getObjectContent() != null) {
            logger.debug("Returning exisiting object {}", (Object)this.getQualifiedName());
            return this.s3Object;
        }
        logger.debug("Getting object {}", (Object)this.getQualifiedName());
        return this.fileSystem.getS3Client().getObject(bucket, key);
    }

    protected boolean isRootBucket() {
        return this.key.equals("");
    }

    public void doAttach() throws Exception {
        logger.debug("Attach called on {}", (Object)this.getQualifiedName());
        this.injectType(FileType.IMAGINARY);
        if (this.isRootBucket()) {
            this.injectType(FileType.FOLDER);
            return;
        }
        try {
            this.s3ObjectMetadata = this.fileSystem.getS3Client().getObjectMetadata(this.bucketName, this.key);
            this.injectType(this.getName().getType());
        }
        catch (AmazonS3Exception e) {
            this.handleAttachException(this.key, this.bucketName);
        }
        finally {
            this.closeS3Object();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAttachException(String key, String bucket) throws IOException {
        block8: {
            String keyWithDelimiter = key + DELIMITER;
            try {
                this.s3ObjectMetadata = this.fileSystem.getS3Client().getObjectMetadata(this.bucketName, key);
                this.injectType(FileType.FOLDER);
                this.key = keyWithDelimiter;
            }
            catch (AmazonS3Exception e1) {
                String errorCode = e1.getErrorCode();
                try {
                    if (errorCode.equals("404 Not Found")) {
                        this.s3Object = this.getS3Object(keyWithDelimiter, bucket);
                        this.s3ObjectMetadata = this.s3Object.getObjectMetadata();
                        this.injectType(FileType.FOLDER);
                        this.key = keyWithDelimiter;
                        break block8;
                    }
                    this.handleAttachExceptionFallback(bucket, keyWithDelimiter, e1);
                }
                catch (AmazonS3Exception e2) {
                    this.handleAttachExceptionFallback(bucket, keyWithDelimiter, e2);
                }
            }
            finally {
                this.closeS3Object();
            }
        }
    }

    private void handleAttachExceptionFallback(String bucket, String keyWithDelimiter, AmazonS3Exception exception) throws FileSystemException {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest().withBucketName(bucket).withPrefix(keyWithDelimiter).withDelimiter(DELIMITER);
        ObjectListing ol = this.fileSystem.getS3Client().listObjects(listObjectsRequest);
        if (!ol.getCommonPrefixes().isEmpty() || !ol.getObjectSummaries().isEmpty()) {
            this.injectType(FileType.FOLDER);
        } else {
            String errorCode = exception.getErrorCode();
            if (!errorCode.equals("NoSuchKey")) {
                logger.error("Could not get information on " + this.getQualifiedName(), (Throwable)exception);
                throw new FileSystemException("vfs.provider/get-type.error", (Object)this.getQualifiedName(), (Throwable)exception);
            }
        }
    }

    private void closeS3Object() throws IOException {
        if (this.s3Object != null) {
            this.s3Object.close();
            this.s3Object = null;
        }
    }

    public void doDetach() throws Exception {
        logger.debug("detaching {}", (Object)this.getQualifiedName());
        this.closeS3Object();
    }

    protected void doDelete() throws FileSystemException {
        this.doDelete(this.key, this.bucketName);
    }

    protected void doDelete(String key, String bucketName) throws FileSystemException {
        if (this.getType() == FileType.FOLDER) {
            ObjectListing ol = this.fileSystem.getS3Client().listObjects(bucketName, key);
            ArrayList allSummaries = new ArrayList(ol.getObjectSummaries());
            while (ol.isTruncated()) {
                ol = this.fileSystem.getS3Client().listNextBatchOfObjects(ol);
                allSummaries.addAll(ol.getObjectSummaries());
            }
            for (S3ObjectSummary s3os : allSummaries) {
                this.fileSystem.getS3Client().deleteObject(bucketName, s3os.getKey());
            }
        }
        this.fileSystem.getS3Client().deleteObject(bucketName, key);
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new S3CommonPipedOutputStream(this.fileSystem, this.bucketName, this.key);
    }

    public long doGetLastModifiedTime() {
        return this.s3ObjectMetadata.getLastModified().getTime();
    }

    protected void doCreateFolder() throws Exception {
        if (!this.isRootBucket()) {
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(0L);
            metadata.setContentType("binary/octet-stream");
            ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
            PutObjectRequest putObjectRequest = this.createPutObjectRequest(this.bucketName, this.key + DELIMITER, emptyContent, metadata);
            try {
                this.fileSystem.getS3Client().putObject(putObjectRequest);
            }
            catch (AmazonS3Exception e) {
                throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this, (Throwable)e);
            }
        } else {
            throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
        }
    }

    protected PutObjectRequest createPutObjectRequest(String bucketName, String key, InputStream inputStream, ObjectMetadata objectMetadata) {
        return new PutObjectRequest(bucketName, key, inputStream, objectMetadata);
    }

    protected void doRename(FileObject newFile) throws Exception {
        if (this.getType().equals((Object)FileType.FOLDER)) {
            throw new FileSystemException("vfs.provider/rename-not-supported.error");
        }
        this.s3ObjectMetadata = this.fileSystem.getS3Client().getObjectMetadata(this.bucketName, this.key);
        if (this.s3ObjectMetadata == null) {
            throw new FileSystemException("vfs.provider/rename.error", new Object[]{this, newFile});
        }
        S3CommonFileObject dest = (S3CommonFileObject)newFile;
        CopyObjectRequest copyObjRequest = this.createCopyObjectRequest(this.bucketName, this.key, dest.bucketName, dest.key);
        this.fileSystem.getS3Client().copyObject(copyObjRequest);
        this.delete();
    }

    protected CopyObjectRequest createCopyObjectRequest(String sourceBucket, String sourceKey, String destBucket, String destKey) {
        return new CopyObjectRequest(sourceBucket, sourceKey, destBucket, destKey);
    }

    protected String getQualifiedName() {
        return this.getQualifiedName(this);
    }

    protected String getQualifiedName(S3CommonFileObject s3nFileObject) {
        return s3nFileObject.bucketName + DELIMITER + s3nFileObject.key;
    }
}

