/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeCache;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.ImmutableDataAttributes;
import org.pentaho.reporting.libraries.base.boot.SingletonHint;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.LFUMap;

@SingletonHint
public class DefaultDataAttributeCache
implements DataAttributeCache {
    private LFUMap<CacheKey, ImmutableDataAttributes> backend;

    public DefaultDataAttributeCache() {
        DebugLog.log((Object)this.toString());
        this.backend = new LFUMap(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableDataAttributes normalize(DataAttributes attrs, DataAttributeContext context) {
        ImmutableDataAttributes key = ImmutableDataAttributes.create(attrs, context);
        CacheKey cacheKey = new CacheKey(context, key);
        DefaultDataAttributeCache defaultDataAttributeCache = this;
        synchronized (defaultDataAttributeCache) {
            ImmutableDataAttributes fromCache = (ImmutableDataAttributes)this.backend.get((Object)cacheKey);
            if (fromCache == null) {
                this.backend.put((Object)cacheKey, (Object)key);
                return key;
            }
            return fromCache;
        }
    }

    private static class CacheKey {
        private final String locale;
        private final String outputType;
        private final ImmutableDataAttributes attrs;

        private CacheKey(DataAttributeContext context, ImmutableDataAttributes attrs) {
            this.locale = context.getLocale().toLanguageTag();
            this.outputType = context.getOutputProcessorMetaData().getExportDescriptor();
            this.attrs = attrs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.locale != null ? !this.locale.equals(cacheKey.locale) : cacheKey.locale != null) {
                return false;
            }
            if (this.outputType != null ? !this.outputType.equals(cacheKey.outputType) : cacheKey.outputType != null) {
                return false;
            }
            return !(this.attrs != null ? !this.attrs.equals(cacheKey.attrs) : cacheKey.attrs != null);
        }

        public int hashCode() {
            int result = this.locale != null ? this.locale.hashCode() : 0;
            result = 31 * result + (this.outputType != null ? this.outputType.hashCode() : 0);
            result = 31 * result + (this.attrs != null ? this.attrs.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CacheKey{locale='" + this.locale + '\'' + ", outputType='" + this.outputType + '\'' + ", attrs=" + this.attrs + '}';
        }
    }
}

