/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.AggregationFunction;
import org.pentaho.reporting.engine.classic.core.function.FieldAggregationFunction;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class AggregateFieldPreProcessor
extends AbstractReportPreProcessor {
    private static final Log logger = LogFactory.getLog(AggregateFieldPreProcessor.class);
    private HashSet<String> generatedExpressionNames;
    private DataSchema schema;
    private AbstractReportDefinition definition;
    private Group[] groups;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            this.definition = definition;
            this.schema = flowController.getDataSchema();
            this.groups = AutoGeneratorUtility.getGroups(definition);
            this.processSection(definition);
            MasterReport masterReport = definition;
            return masterReport;
        }
        finally {
            this.groups = null;
            this.definition = null;
            this.schema = null;
            this.generatedExpressionNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        try {
            this.generatedExpressionNames = new HashSet();
            this.definition = definition;
            this.schema = flowController.getDataSchema();
            this.groups = AutoGeneratorUtility.getGroups(definition);
            this.processSection(definition);
            SubReport subReport = definition;
            return subReport;
        }
        finally {
            this.groups = null;
            this.definition = null;
            this.schema = null;
            this.generatedExpressionNames = null;
        }
    }

    private void processSection(Section section) throws ReportProcessingException {
        int count = section.getElementCount();
        for (int i = 0; i < count; ++i) {
            Class aggType;
            Element element = section.getElement(i);
            if (element instanceof SubReport) continue;
            if (element instanceof Section) {
                this.processSection((Section)element);
                continue;
            }
            Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type");
            if (!(attribute instanceof Class) || !AggregationFunction.class.isAssignableFrom(aggType = (Class)attribute)) continue;
            try {
                this.processAggregateElement(element, aggType);
                continue;
            }
            catch (Exception e) {
                throw new ReportProcessingException("Failed to pre-process the report", e);
            }
        }
    }

    protected void processAggregateElement(ReportElement element, Class<AggregationFunction> aggType) throws InstantiationException, IllegalAccessException, ReportProcessingException {
        Object labelFor;
        AggregationFunction o = aggType.newInstance();
        if (!this.configureCrosstabAggregation(element, o)) {
            this.configureRelationalAggreation(element, o);
        }
        String fieldName = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o instanceof FieldAggregationFunction) {
            FieldAggregationFunction fo = (FieldAggregationFunction)o;
            fo.setField(fieldName);
        }
        if ((labelFor = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for")) == null) {
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", fieldName);
        }
        String name = AutoGeneratorUtility.generateUniqueExpressionName(this.schema, "::wizard:aggregation:{0}", this.generatedExpressionNames.toArray(new String[this.generatedExpressionNames.size()]));
        o.setName(name);
        this.generatedExpressionNames.add(name);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", name);
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-type", null);
        this.definition.addExpression(o);
    }

    private void configureRelationalAggreation(ReportElement element, AggregationFunction o) {
        String group = (String)element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "aggregation-group");
        if (group != null) {
            o.setGroup(group);
        } else {
            Group g = this.findGroup(element);
            if (g != null) {
                o.setGroup(g.getGeneratedName());
            }
        }
    }

    private boolean configureCrosstabAggregation(ReportElement element, AggregationFunction o) throws ReportProcessingException {
        Section containingGroup;
        Section containingBody;
        CrosstabCell crosstabCell = this.findCrosstabCell(element);
        if (crosstabCell == null) {
            return false;
        }
        String columnField = crosstabCell.getColumnField();
        String rowField = crosstabCell.getRowField();
        if (columnField == null && rowField == null) {
            CrosstabColumnGroup group = (CrosstabColumnGroup)this.groups[this.groups.length - 1];
            String name = group.getName();
            o.setGroup(name);
            o.setCrosstabFilterGroup(null);
            return true;
        }
        if (rowField == null) {
            CrosstabRowGroup lastRowGroup = this.findLastRowGroup();
            o.setGroup(lastRowGroup.getName());
        } else {
            CrosstabRowGroup rowGroup = this.findRowGroup(rowField);
            containingBody = rowGroup.getParentSection();
            containingGroup = containingBody.getParentSection();
            o.setGroup(containingGroup.getName());
        }
        if (columnField == null) {
            Group lastColumnGroup = this.groups[this.groups.length - 1];
            o.setCrosstabFilterGroup(lastColumnGroup.getName());
        } else {
            CrosstabColumnGroup columnGroup = this.findColumnGroup(columnField);
            containingBody = columnGroup.getParentSection();
            containingGroup = containingBody.getParentSection();
            if (containingGroup instanceof CrosstabColumnGroup) {
                o.setCrosstabFilterGroup(containingGroup.getName());
            }
        }
        logger.debug((Object)("Aggregation-Configuration: " + o.getClass()));
        logger.debug((Object)(" - column         : " + columnField));
        logger.debug((Object)(" - row            : " + rowField));
        logger.debug((Object)(" - filter-group   : " + o.getCrosstabFilterGroup()));
        logger.debug((Object)(" - reset-group    : " + o.getGroup()));
        return true;
    }

    private CrosstabRowGroup findLastRowGroup() throws ReportProcessingException {
        for (int i = this.groups.length - 1; i >= 0; --i) {
            Group group = this.groups[i];
            if (!(group instanceof CrosstabRowGroup)) continue;
            return (CrosstabRowGroup)group;
        }
        throw new ReportProcessingException("Trying to find a crosstab-row, but there is none.");
    }

    private Group findGroup(ReportElement element) {
        for (Section parentSection = element.getParentSection(); parentSection != null && !(parentSection instanceof ReportDefinition); parentSection = parentSection.getParentSection()) {
            if (!(parentSection instanceof Group)) continue;
            return (Group)parentSection;
        }
        return null;
    }

    private CrosstabRowGroup findRowGroup(String field) throws ReportProcessingException {
        for (int i = 0; i < this.groups.length; ++i) {
            CrosstabRowGroup rowGroup;
            Group group = this.groups[i];
            if (!(group instanceof CrosstabRowGroup) || !ObjectUtilities.equal((Object)(rowGroup = (CrosstabRowGroup)group).getField(), (Object)field)) continue;
            return rowGroup;
        }
        throw new ReportProcessingException("Trying to find a crosstab-row for field '" + field + "', but there is none.");
    }

    private CrosstabColumnGroup findColumnGroup(String field) throws ReportProcessingException {
        for (int i = 0; i < this.groups.length; ++i) {
            CrosstabColumnGroup columnGroup;
            Group group = this.groups[i];
            if (!(group instanceof CrosstabColumnGroup) || !ObjectUtilities.equal((Object)(columnGroup = (CrosstabColumnGroup)group).getField(), (Object)field)) continue;
            return columnGroup;
        }
        throw new ReportProcessingException("Trying to find a crosstab-column for field '" + field + "', but there is none.");
    }

    private CrosstabCell findCrosstabCell(ReportElement element) {
        for (Section parentSection = element.getParentSection(); parentSection != null && !(parentSection instanceof ReportDefinition); parentSection = parentSection.getParentSection()) {
            if (!(parentSection instanceof CrosstabCell)) continue;
            return (CrosstabCell)parentSection;
        }
        return null;
    }
}

