/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.FastGlobalView;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeHandler;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;

public class PaddingController
implements Cloneable {
    private static final Log logger = LogFactory.getLog(PaddingController.class);
    private int currentCursorPosition;
    private CrosstabSpecification crosstabSpecification;
    private Object[] key;
    private String[] columnNames;
    private Object[] rowKey;
    private String[] rowNames;
    private HashSet<String> knownNames;
    private HashSet<String> knownRowNames;

    public PaddingController(PaddingController dataRow) {
        this.currentCursorPosition = dataRow.currentCursorPosition;
        this.crosstabSpecification = dataRow.crosstabSpecification;
        this.key = (Object[])dataRow.key.clone();
        this.rowKey = (Object[])dataRow.rowKey.clone();
        this.columnNames = dataRow.columnNames;
        this.rowNames = dataRow.rowNames;
        this.knownNames = dataRow.knownNames;
        this.knownRowNames = dataRow.knownRowNames;
    }

    public PaddingController(CrosstabSpecification crosstabSpecification) {
        if (crosstabSpecification == null) {
            throw new NullPointerException();
        }
        this.crosstabSpecification = crosstabSpecification;
        this.columnNames = this.crosstabSpecification.getColumnDimensionNames();
        this.rowNames = this.crosstabSpecification.getRowDimensionNames();
        this.key = new Object[this.columnNames.length];
        this.rowKey = new Object[this.rowNames.length];
        this.currentCursorPosition = 0;
        this.knownNames = new HashSet();
        this.knownNames.addAll(Arrays.asList(this.columnNames));
        this.knownNames.addAll(Arrays.asList(this.rowNames));
        this.knownRowNames = new HashSet();
        this.knownRowNames.addAll(Arrays.asList(this.rowNames));
    }

    public int getPrePaddingRows(DataRow globalView) {
        if (this.key.length == 0) {
            return 0;
        }
        for (int i = 0; i < this.key.length; ++i) {
            this.key[i] = globalView.get(this.columnNames[i]);
        }
        int computedPosition = this.crosstabSpecification.indexOf(this.currentCursorPosition, this.key);
        if (computedPosition < 0) {
            return 0;
        }
        return computedPosition - this.currentCursorPosition;
    }

    public int getCurrentCursorPosition() {
        return this.currentCursorPosition;
    }

    public int getCrosstabColumnCount() {
        return this.crosstabSpecification.size();
    }

    private String printKey(Object[] data) {
        StringBuffer s = new StringBuffer("{");
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                s.append(',');
            }
            s.append(data[i]);
        }
        return s + "}";
    }

    public PaddingController advance() {
        PaddingController dataRow = new PaddingController(this);
        ++dataRow.currentCursorPosition;
        return dataRow;
    }

    public void activate(MasterDataRowChangeHandler dataRow) {
        if (this.key.length == 0) {
            return;
        }
        if (this.currentCursorPosition >= this.crosstabSpecification.size()) {
            throw new IllegalStateException();
        }
        Object[] currentColumn = this.crosstabSpecification.getKeyAt(this.currentCursorPosition);
        MasterDataRowChangeEvent event = dataRow.getReusableEvent();
        event.reuse(3, "", "");
        for (int i = 0; i < this.columnNames.length; ++i) {
            event.setColumnName(this.columnNames[i]);
            event.setColumnValue(currentColumn[i]);
            event.setOptional(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replacing Column-dimension value: " + this.columnNames[i] + " = " + currentColumn[i]));
            }
            dataRow.dataRowChanged(event);
        }
    }

    public void refreshPaddedRow(MasterDataRowChangeHandler dataRow, ReportDataRow reportDataRow) {
        if (reportDataRow == null) {
            return;
        }
        MasterDataRowChangeEvent chEvent = dataRow.getReusableEvent();
        chEvent.reuse(3, "", "");
        int columnCount = reportDataRow.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String name = reportDataRow.getColumnName(i);
            if (this.knownRowNames.contains(name)) {
                chEvent.setColumnName(name);
                chEvent.setColumnValue(reportDataRow.get(i));
            } else {
                if (this.knownNames.contains(name)) continue;
                chEvent.setColumnName(name);
                chEvent.setColumnValue(null);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Replacing padded value: " + name + " = " + chEvent.getColumnValue()));
            }
            dataRow.dataRowChanged(chEvent);
        }
    }

    public void refreshRow(MasterDataRowChangeHandler dataRow, ReportDataRow reportDataRow) {
        if (reportDataRow == null) {
            return;
        }
        MasterDataRowChangeEvent chEvent = dataRow.getReusableEvent();
        chEvent.reuse(3, "", "");
        int columnCount = reportDataRow.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String name = reportDataRow.getColumnName(i);
            if (!this.knownRowNames.contains(name) && this.knownNames.contains(name)) continue;
            chEvent.setColumnName(name);
            chEvent.setColumnValue(reportDataRow.get(i));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Refreshing value: " + name + " = " + chEvent.getColumnValue()));
            }
            dataRow.dataRowChanged(chEvent);
        }
    }

    public PaddingController resetRowCursor() {
        PaddingController dataRow = new PaddingController(this);
        dataRow.currentCursorPosition = 0;
        return dataRow;
    }

    public Object[] createRowKey(FastGlobalView globalView) {
        Object[] rowKey = new Object[this.rowNames.length];
        for (int i = 0; i < rowKey.length; ++i) {
            rowKey[i] = globalView.get(this.rowNames[i]);
        }
        return rowKey;
    }

    public Object[] createColumnKey(FastGlobalView globalView) {
        Object[] colKey = new Object[this.columnNames.length];
        for (int i = 0; i < colKey.length; ++i) {
            colKey[i] = globalView.get(this.columnNames[i]);
        }
        return colKey;
    }

    public CrosstabSpecification getCrosstabSpecification() {
        return this.crosstabSpecification;
    }

    public PaddingController clone() {
        try {
            return (PaddingController)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }
}

