/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class GroupHeaderReadHandler
extends RootLevelBandReadHandler {
    private static final Log logger = LogFactory.getLog(GroupHeaderReadHandler.class);

    public GroupHeaderReadHandler(Band band) {
        super(band);
    }

    @Override
    protected void startParsing(PropertyAttributes attr) throws SAXException {
        super.startParsing(attr);
        this.handlePagebreakAttr(attr);
        this.handleRepeat(attr);
        this.handleSticky(attr);
    }

    private void handleSticky(PropertyAttributes attr) throws SAXException {
        String repeat = attr.getValue(this.getUri(), "sticky");
        Boolean repeatVal = ParserUtil.parseBoolean((String)repeat, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.STICKY, repeatVal);
    }

    private void handleRepeat(PropertyAttributes attr) throws SAXException {
        String repeat = attr.getValue(this.getUri(), "repeat");
        Boolean repeatVal = ParserUtil.parseBoolean((String)repeat, (Locator)this.getLocator());
        this.getBand().getStyle().setStyleProperty(BandStyleKeys.REPEAT_HEADER, repeatVal);
    }

    private void handlePagebreakAttr(PropertyAttributes attr) throws SAXException {
        String ownPageAttr = attr.getValue(this.getUri(), "pagebreak");
        if (ownPageAttr != null) {
            logger.warn((Object)"The 'pagebreak' attribute of the <group-header> tag is deprecated. Use the 'pagebreak-before' attribute instead.");
            Boolean ownPage = ParserUtil.parseBoolean((String)ownPageAttr, (Locator)this.getLocator());
            this.getBand().getStyle().setStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, ownPage);
        }
    }
}

