/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.util.beans.ColorValueConverter;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ContentStyleReadHandler
extends AbstractXmlReadHandler
implements StyleReadHandler {
    private ElementStyleSheet styleSheet;
    private ColorValueConverter colorValueConverter = new ColorValueConverter();

    public ElementStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public void setStyleSheet(ElementStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String fillColor;
        String color;
        String excelCellFormat;
        Stroke stroke;
        String keepAspectRatio;
        String scale;
        String dynamicHeight;
        String fillShape;
        String drawShape;
        String antiAliasing = attrs.getValue(this.getUri(), "anti-aliasing");
        if (antiAliasing != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.ANTI_ALIASING, "true".equals(antiAliasing));
        }
        if ((drawShape = attrs.getValue(this.getUri(), "draw-shape")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE, "true".equals(drawShape));
        }
        if ((fillShape = attrs.getValue(this.getUri(), "fill-shape")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE, "true".equals(fillShape));
        }
        if ((dynamicHeight = attrs.getValue(this.getUri(), "dynamic-height")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, "true".equals(dynamicHeight));
        }
        if ((scale = attrs.getValue(this.getUri(), "scale")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.SCALE, "true".equals(scale));
        }
        if ((keepAspectRatio = attrs.getValue(this.getUri(), "keep-aspect-ratio")) != null) {
            this.styleSheet.setBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, "true".equals(keepAspectRatio));
        }
        if ((stroke = this.readStroke(attrs)) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.STROKE, stroke);
        }
        if ((excelCellFormat = attrs.getValue(this.getUri(), "excel-cell-format")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING, excelCellFormat);
        }
        if ((color = attrs.getValue(this.getUri(), "color")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.PAINT, ReportParserUtil.parseColor(color, null));
        }
        if ((fillColor = attrs.getValue(this.getUri(), "fill-color")) != null) {
            this.styleSheet.setStyleProperty(ElementStyleKeys.FILL_COLOR, ReportParserUtil.parseColor(fillColor, null));
        }
    }

    private Stroke readStroke(Attributes atts) throws ParseException {
        String strokeStyle = atts.getValue(this.getUri(), "stroke-style");
        String weightAttr = atts.getValue(this.getUri(), "stroke-weight");
        if (strokeStyle == null && weightAttr == null) {
            return null;
        }
        float weight = 1.0f;
        if (weightAttr != null) {
            weight = ParserUtil.parseFloat((String)weightAttr, (String)"Weight is given, but not a number.", (Locator)this.getLocator());
        }
        return ReportParserUtil.parseStroke(strokeStyle, weight);
    }

    public Object getObject() throws SAXException {
        return this.styleSheet;
    }
}

