/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base;

import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.CompoundResource;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class ReportResource
extends CompoundResource {
    private boolean cloneable;

    public ReportResource(ResourceKey source, DependencyCollector dependencies, Object product, Class targetType, boolean clone) {
        super(source, dependencies, product, targetType);
        if (product instanceof Cloneable) {
            this.cloneable = clone;
        }
    }

    public boolean isTemporaryResult() {
        return !this.cloneable;
    }

    public Object getResource() throws ResourceException {
        try {
            Object resource = super.getResource();
            if (this.cloneable) {
                return ObjectUtilities.clone((Object)resource);
            }
            return resource;
        }
        catch (CloneNotSupportedException e) {
            throw new ResourceException("Unable to retrieve the resource.", (Exception)e);
        }
    }
}

