/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html;

import java.awt.Color;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderCorner;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.LogicalPageKey;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlRowBackgroundStruct;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlTextExtractor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriteException;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.AbstractHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.ContentUrlReWriteService;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultHtmlContentGenerator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.DefaultStyleBuilderFactory;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.WriterService;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class HtmlPrinter
extends AbstractHtmlPrinter
implements ContentUrlReWriteService {
    private static final Log logger = LogFactory.getLog(HtmlPrinter.class);
    private boolean assumeZeroMargins = true;
    private boolean assumeZeroBorders = true;
    private boolean assumeZeroPaddings = true;
    private ContentLocation contentLocation;
    private NameGenerator contentNameGenerator;
    private URLRewriter urlRewriter = new FileSystemURLRewriter();
    private ContentItem documentContentItem;
    private HtmlTextExtractor textExtractor;
    private CellBackgroundProducer cellBackgroundProducer;
    private WriterService writer;

    protected HtmlPrinter(ResourceManager resourceManager) {
        super(resourceManager);
    }

    @Override
    public String rewriteContentDataItem(ContentItem item) throws URLRewriteException {
        return this.urlRewriter.rewrite((ContentEntity)this.documentContentItem, (ContentEntity)item);
    }

    protected boolean isAssumeZeroMargins() {
        return this.assumeZeroMargins;
    }

    protected void setAssumeZeroMargins(boolean assumeZeroMargins) {
        this.assumeZeroMargins = assumeZeroMargins;
    }

    protected boolean isAssumeZeroBorders() {
        return this.assumeZeroBorders;
    }

    protected void setAssumeZeroBorders(boolean assumeZeroBorders) {
        this.assumeZeroBorders = assumeZeroBorders;
    }

    protected boolean isAssumeZeroPaddings() {
        return this.assumeZeroPaddings;
    }

    protected void setAssumeZeroPaddings(boolean assumeZeroPaddings) {
        this.assumeZeroPaddings = assumeZeroPaddings;
    }

    public ContentLocation getContentLocation() {
        return this.contentLocation;
    }

    public NameGenerator getContentNameGenerator() {
        return this.contentNameGenerator;
    }

    @Override
    protected ContentUrlReWriteService getContentReWriteService() {
        return this;
    }

    public void setContentWriter(ContentLocation contentLocation, NameGenerator contentNameGenerator) {
        this.contentNameGenerator = contentNameGenerator;
        this.contentLocation = contentLocation;
    }

    public URLRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        if (urlRewriter == null) {
            throw new NullPointerException();
        }
        this.urlRewriter = urlRewriter;
    }

    public ContentItem getDocumentContentItem() {
        return this.documentContentItem;
    }

    protected void setDocumentContentItem(ContentItem documentContentItem) {
        this.documentContentItem = documentContentItem;
    }

    private HtmlRowBackgroundStruct getCommonBackground(LogicalPageBox logicalPageBox, SheetLayout sheetLayout, int row, TableContentProducer tableContentProducer) {
        Color color = null;
        BorderEdge topEdge = BorderEdge.EMPTY;
        BorderEdge bottomEdge = BorderEdge.EMPTY;
        int columnCount = sheetLayout.getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            CellBackground backgroundAt;
            CellMarker.SectionType sectionType = tableContentProducer.getSectionType(row, col);
            RenderBox content = tableContentProducer.getContent(row, col);
            if (content == null) {
                RenderBox background = tableContentProducer.getBackground(row, col);
                backgroundAt = background != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, col, row, 1, 1, false, sectionType, background) : this.cellBackgroundProducer.getBackgroundAt(logicalPageBox, sheetLayout, col, row, false, sectionType);
            } else {
                long contentOffset = tableContentProducer.getContentOffset(row, col);
                int colSpan = sheetLayout.getColSpan(col, content.getX() + content.getWidth());
                int rowSpan = sheetLayout.getRowSpan(row, content.getY() + content.getHeight() + contentOffset);
                backgroundAt = this.cellBackgroundProducer.getBackgroundForBox(logicalPageBox, sheetLayout, col, row, colSpan, rowSpan, false, sectionType, content);
            }
            if (backgroundAt == null) {
                HtmlRowBackgroundStruct struct = new HtmlRowBackgroundStruct();
                struct.fail();
                return struct;
            }
            boolean fail = false;
            if (col == 0) {
                color = backgroundAt.getBackgroundColor();
                topEdge = backgroundAt.getTop();
                bottomEdge = backgroundAt.getBottom();
            } else {
                if (!ObjectUtilities.equal((Object)color, (Object)backgroundAt.getBackgroundColor())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)topEdge, (Object)backgroundAt.getTop())) {
                    fail = true;
                }
                if (!ObjectUtilities.equal((Object)bottomEdge, (Object)backgroundAt.getBottom())) {
                    fail = true;
                }
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getBottomRight())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopLeft())) {
                fail = true;
            }
            if (!BorderCorner.EMPTY.equals(backgroundAt.getTopRight())) {
                fail = true;
            }
            if (!fail) continue;
            HtmlRowBackgroundStruct struct = new HtmlRowBackgroundStruct();
            struct.fail();
            return struct;
        }
        HtmlRowBackgroundStruct struct = new HtmlRowBackgroundStruct();
        struct.set(color, topEdge, bottomEdge);
        return struct;
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, OutputProcessorMetaData metaData, boolean incremental) throws ContentProcessingException {
        this.print(logicalPageKey, logicalPage, contentProducer, metaData, incremental, true);
    }

    public void print(LogicalPageKey logicalPageKey, LogicalPageBox logicalPage, TableContentProducer contentProducer, OutputProcessorMetaData metaData, boolean incremental, boolean writeAttrs) throws ContentProcessingException {
        block28: {
            try {
                XmlWriter xmlWriter;
                SheetLayout sheetLayout = contentProducer.getSheetLayout();
                int startRow = contentProducer.getFinishedRows();
                int finishRow = contentProducer.getFilledRows();
                if (incremental && startRow == finishRow) {
                    return;
                }
                DefaultHtmlContentGenerator contentGenerator = this.getContentGenerator();
                if (this.documentContentItem == null) {
                    this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
                    this.initialize(metaData.getConfiguration());
                    this.documentContentItem = this.contentLocation.createItem(this.contentNameGenerator.generateName(null, "text/html"));
                    this.writer = this.createWriterService(this.documentContentItem.getOutputStream());
                    xmlWriter = this.writer.getXmlWriter();
                    this.openSheet(logicalPage.getAttributes(), contentProducer.getSheetName(), metaData, sheetLayout, xmlWriter);
                } else {
                    xmlWriter = this.writer.getXmlWriter();
                }
                int colCount = sheetLayout.getColumnCount();
                boolean emptyCellsUseCSS = this.getTagHelper().isEmptyCellsUseCSS();
                StyleBuilder styleBuilder = this.getStyleBuilder();
                DefaultStyleBuilderFactory styleBuilderFactory = this.getStyleBuilderFactory();
                if (this.textExtractor == null) {
                    this.textExtractor = new HtmlTextExtractor(metaData, xmlWriter, contentGenerator, this.getTagHelper());
                }
                for (int row = startRow; row < finishRow; ++row) {
                    int rowHeight = (int)StrictGeomUtility.toExternalValue(sheetLayout.getRowHeight(row));
                    HtmlRowBackgroundStruct struct = this.getCommonBackground(logicalPage, sheetLayout, row, contentProducer);
                    xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "tr", this.getTagHelper().createRowAttributes(rowHeight, struct), false);
                    for (int col = 0; col < colCount; ++col) {
                        Object rawFooterContent;
                        RenderBox content = contentProducer.getContent(row, col);
                        CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                        if (content == null) {
                            RenderBox backgroundBox = contentProducer.getBackground(row, col);
                            CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(logicalPage, sheetLayout, col, row, true, sectionType);
                            this.writeBackgroundCell(background, xmlWriter);
                            continue;
                        }
                        if (!content.isCommited()) {
                            throw new InvalidReportStateException("Uncommited content encountered: " + row + ", " + col + ' ' + content);
                        }
                        long contentOffset = contentProducer.getContentOffset(row, col);
                        long colPos = sheetLayout.getXPosition(col);
                        long rowPos = sheetLayout.getYPosition(row);
                        if ((content.getX() != colPos || content.getY() + contentOffset != rowPos) && content.isFinishedTable()) continue;
                        int colSpan = sheetLayout.getColSpan(col, content.getX() + content.getWidth());
                        int rowSpan = sheetLayout.getRowSpan(row, content.getY() + content.getHeight() + contentOffset);
                        CellBackground realBackground = this.cellBackgroundProducer.getBackgroundForBox(logicalPage, sheetLayout, col, row, colSpan, rowSpan, true, sectionType, content);
                        StyleBuilder cellStyle = styleBuilderFactory.createCellStyle(styleBuilder, content.getStyleSheet(), content.getBoxDefinition(), realBackground, null, null);
                        AttributeList cellAttributes = this.getTagHelper().createCellAttributes(colSpan, rowSpan, content.getAttributes(), content.getStyleSheet(), realBackground, cellStyle);
                        xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "td", cellAttributes, false);
                        Object rawContent = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content");
                        if (rawContent != null) {
                            xmlWriter.writeText(String.valueOf(rawContent));
                        }
                        if (realBackground != null) {
                            String[] anchors = realBackground.getAnchors();
                            for (int i = 0; i < anchors.length; ++i) {
                                String anchor = anchors[i];
                                xmlWriter.writeTag("http://www.w3.org/1999/xhtml", "a", "name", anchor, true);
                            }
                        }
                        if (!(Boolean.TRUE.equals(content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "surpress-content")) || this.textExtractor.performOutput(content, cellStyle.toArray(), writeAttrs) || emptyCellsUseCSS)) {
                            xmlWriter.writeText("&nbsp;");
                        }
                        if ((rawFooterContent = content.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content")) != null) {
                            xmlWriter.writeText(String.valueOf(rawFooterContent));
                        }
                        xmlWriter.writeCloseTag();
                        content.setFinishedTable(true);
                    }
                    xmlWriter.writeCloseTag();
                }
                if (incremental) break block28;
                this.performCloseFile(contentProducer.getSheetName(), logicalPage.getAttributes(), this.writer);
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to close writer instance", (Throwable)e);
                }
                this.textExtractor = null;
                this.writer = null;
                this.documentContentItem = null;
            }
            catch (IOException ioe) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.writer = null;
                this.documentContentItem = null;
                this.textExtractor = null;
                throw new ContentProcessingException("IOError while creating content", ioe);
            }
            catch (ContentIOException e) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.writer = null;
                this.documentContentItem = null;
                this.textExtractor = null;
                throw new ContentProcessingException("Content-IOError while creating content", (Exception)((Object)e));
            }
            catch (URLRewriteException e) {
                try {
                    if (this.writer != null) {
                        this.writer.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.writer = null;
                this.documentContentItem = null;
                this.textExtractor = null;
                throw new ContentProcessingException("Cannot create URL for external stylesheet", e);
            }
        }
    }
}

