/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterComponent;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.ParameterUpdateContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.parameters.TextComponentEditHandler;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.designtime.swing.date.DateChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.date.DateChooserPopupMenu;

public class DatePickerParameterComponent
extends JPanel
implements ParameterComponent {
    private static final Log logger = LogFactory.getLog(DatePickerParameterComponent.class);
    private DateChooserPanel dateChooserPanel;
    private JTextField dateField;
    private DateFormat sdf;
    private ParameterUpdateContext updateContext;
    private JPopupMenu dateWindow;
    private JButton pickDateButton;
    private Class dateType;
    private String parameterName;
    private boolean adjustingToExternalInput;

    public DatePickerParameterComponent(ParameterDefinitionEntry entry, ParameterContext parameterContext, ParameterUpdateContext updateContext) {
        this.parameterName = entry.getName();
        this.updateContext = updateContext;
        this.dateType = entry.getValueType();
        if (this.dateType.isArray()) {
            this.dateType = this.dateType.getComponentType();
        }
        String formatString = entry.getTranslatedParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "data-format", parameterContext);
        String timeZoneSpec = entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "timezone", parameterContext);
        Locale locale = parameterContext.getResourceBundleFactory().getLocale();
        TimeZone timeZone = TextComponentEditHandler.createTimeZone(timeZoneSpec, parameterContext.getResourceBundleFactory().getTimeZone());
        this.sdf = this.createDateFormat(formatString, locale, timeZone);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        this.dateChooserPanel = new DateChooserPanel(calendar, true);
        this.dateChooserPanel.addPropertyChangeListener("date", (PropertyChangeListener)new InternalDateUpdateHandler());
        this.dateField = new JTextField();
        this.dateField.setColumns(20);
        TextComponentEditHandler listener = new TextComponentEditHandler(entry.getValueType(), entry.getName(), this.dateField, updateContext, this.sdf);
        this.dateField.getDocument().addDocumentListener(listener);
        this.dateField.addActionListener(listener);
        this.setLayout(new BorderLayout());
        this.dateField.setEditable(true);
        this.pickDateButton = new JButton(new PickDateListener());
        JPanel datePanel = new JPanel(new FlowLayout());
        datePanel.add(this.dateField);
        datePanel.add(this.pickDateButton);
        this.add((Component)datePanel, "West");
        this.updateContext.addChangeListener(new DateUpdateHandler(this.parameterName));
    }

    DateFormat createDateFormat(String parameterFormatString, Locale locale, TimeZone timeZone) {
        if (parameterFormatString != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(parameterFormatString, locale);
                dateFormat.setTimeZone(timeZone);
                dateFormat.setLenient(false);
                return dateFormat;
            }
            catch (Exception e) {
                logger.warn((Object)"Parameter format-string for date-parameter was not a valid date-format-string", (Throwable)e);
            }
        }
        DateFormat dateTimeInstance = DateFormat.getDateTimeInstance(1, 1, locale);
        dateTimeInstance.setTimeZone(timeZone);
        dateTimeInstance.setLenient(false);
        return dateTimeInstance;
    }

    private void setDate(Object value) {
        if (this.dateWindow != null && this.dateWindow.isVisible()) {
            this.dateWindow.setVisible(false);
        }
        if (value == null || "".equals(value)) {
            return;
        }
        if (value instanceof String) {
            try {
                Date date = (Date)ConverterRegistry.toPropertyValue((String)value, this.dateType);
                this.dateChooserPanel.setDateSelected(false);
                this.dateChooserPanel.setDate(date);
                this.dateField.setText(this.sdf.format(date));
                if (!this.adjustingToExternalInput) {
                    this.updateContext.setParameterValue(this.parameterName, this.dateChooserPanel.getDate());
                }
            }
            catch (Exception e) {
                logger.debug((Object)"Unparsable date-string", (Throwable)e);
            }
        } else if (value instanceof Date) {
            Date date = (Date)value;
            this.dateChooserPanel.setDateSelected(false);
            this.dateChooserPanel.setDate(date);
            this.dateField.setText(this.sdf.format(date));
            if (!this.adjustingToExternalInput) {
                this.updateContext.setParameterValue(this.parameterName, this.dateChooserPanel.getDate());
            }
        } else {
            logger.debug((Object)("Date-parameter must be set either as normalized date-string or as date-object: " + value + " [" + value.getClass() + "]"));
        }
    }

    @Override
    public JComponent getUIComponent() {
        return this;
    }

    @Override
    public void initialize() throws ReportDataFactoryException {
        Object value = this.updateContext.getParameterValue(this.parameterName);
        if (value != null) {
            try {
                this.adjustingToExternalInput = true;
                this.setDate(value);
            }
            finally {
                this.adjustingToExternalInput = false;
            }
        }
    }

    private class InternalDateUpdateHandler
    implements PropertyChangeListener {
        private InternalDateUpdateHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            if (DatePickerParameterComponent.this.adjustingToExternalInput) {
                return;
            }
            if (!"date".equals(changeEvent.getPropertyName())) {
                return;
            }
            Date date = (Date)changeEvent.getNewValue();
            if (date == null) {
                DatePickerParameterComponent.this.dateField.setText(null);
            } else {
                DatePickerParameterComponent.this.dateField.setText(DatePickerParameterComponent.this.sdf.format(date));
            }
            if (DatePickerParameterComponent.this.dateChooserPanel.isDateSelected()) {
                DatePickerParameterComponent.this.dateWindow.setVisible(false);
            }
            DatePickerParameterComponent.this.updateContext.setParameterValue(DatePickerParameterComponent.this.parameterName, date);
        }
    }

    private class PickDateListener
    extends AbstractAction {
        private PickDateListener() {
            URL iconRes = this.getClass().getResource("/org/pentaho/reporting/engine/classic/core/modules/gui/base/date/datepicker.png");
            if (iconRes != null) {
                this.putValue("SmallIcon", new ImageIcon(iconRes));
            } else {
                this.putValue("Name", "..");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DatePickerParameterComponent.this.dateWindow != null && DatePickerParameterComponent.this.dateWindow.isVisible()) {
                return;
            }
            if (DatePickerParameterComponent.this.dateWindow == null) {
                DatePickerParameterComponent.this.dateChooserPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                DatePickerParameterComponent.this.dateWindow = (JPopupMenu)new DateChooserPopupMenu(DatePickerParameterComponent.this.dateChooserPanel);
                DatePickerParameterComponent.this.dateWindow.setLayout(new BorderLayout());
                DatePickerParameterComponent.this.dateWindow.add((Component)DatePickerParameterComponent.this.dateChooserPanel, "Center");
                DatePickerParameterComponent.this.dateWindow.pack();
            }
            DatePickerParameterComponent.this.dateChooserPanel.setDateSelected(false);
            DatePickerParameterComponent.this.dateWindow.show(DatePickerParameterComponent.this, 0, DatePickerParameterComponent.this.pickDateButton.getHeight());
        }
    }

    private class DateUpdateHandler
    implements ChangeListener {
        private String parameterName;

        private DateUpdateHandler(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object value = DatePickerParameterComponent.this.updateContext.getParameterValue(this.parameterName);
            if (value != null) {
                try {
                    DatePickerParameterComponent.this.adjustingToExternalInput = true;
                    DatePickerParameterComponent.this.setDate(value);
                }
                finally {
                    DatePickerParameterComponent.this.adjustingToExternalInput = false;
                }
            }
        }
    }
}

