/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class RenderBoxNonAutoIterator
implements Iterator<RenderNode> {
    private RenderNode result;
    private boolean beforeStart;
    private FastStack<RenderBox> boxes;

    public RenderBoxNonAutoIterator(RenderBox sectionRenderBox) {
        this.result = sectionRenderBox.getFirstChild();
        this.beforeStart = true;
    }

    @Override
    public boolean hasNext() {
        if (this.beforeStart) {
            this.beforeStart = false;
            this.findNonAuto();
            return this.result != null;
        }
        if (this.result == null) {
            return false;
        }
        this.result = this.result.getNext();
        this.findNonAuto();
        return this.result != null;
    }

    private void findNonAuto() {
        block0: while (this.result != null && this.result.getNodeType() == 524290) {
            RenderBox box = (RenderBox)this.result;
            RenderNode firstChild = box.getFirstChild();
            if (firstChild != null) {
                if (this.boxes == null) {
                    this.boxes = new FastStack();
                }
                this.boxes.push((Object)box);
                this.result = firstChild;
                continue;
            }
            this.result = this.result.getNext();
            if (this.result != null || this.boxes == null) continue;
            while (!this.boxes.isEmpty()) {
                RenderBox parent = (RenderBox)this.boxes.pop();
                this.result = parent.getNext();
                if (this.result == null) continue;
                continue block0;
            }
        }
    }

    @Override
    public RenderNode next() {
        if (this.beforeStart) {
            return null;
        }
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

